document.addEventListener("DOMContentLoaded", () => {
    const tableBody = document.querySelector(".table tbody");
    const addForm = document.getElementById("add-material-form");
    const removeForm = document.getElementById("remove-material-form");
    const searchBar = document.getElementById("search-bar");

    // Funkcija, lai iegūtu materiālus
    const fetchMaterials = async () => {
        try {
            const response = await fetch("../php/material-count.php");
            const materials = await response.json();

            if (Array.isArray(materials)) {
                renderTable(materials);
            } else if (materials.error) {
                alert(materials.error);
            }
        } catch (error) {
            console.error("Kļūda, iegūstot materiālus:", error);
        }
    };

    // Funkcija, lai attēlotu materiālu tabulu
    const renderTable = (materials) => {
        tableBody.innerHTML = "";
        materials.forEach((material) => {
            const statusClass =
                material.status === "Pietiekami"
                    ? "status-green"
                    : material.status === "Mazāk par normu"
                        ? "status-orange"
                        : "status-red";

            tableBody.innerHTML += `
                <tr>
                    <td>${material.sku_code}</td>
                    <td>${material.material_type}</td>
                    <td>${material.material_size}</td>
                    <td>${material.material_count}</td>
                    <td class="${statusClass}">${material.status}</td>
                </tr>
            `;
        });
    };

    // Materiāla pievienošana
    addForm.addEventListener("submit", async (e) => {
        e.preventDefault();

        const formData = new FormData(addForm);
        const materialData = Object.fromEntries(formData.entries());

        try {
            const response = await fetch("../php/material-count.php?action=add", {
                method: "POST",
                headers: { "Content-Type": "application/json" },
                body: JSON.stringify(materialData),
            });

            const result = await response.json();
            if (result.success) {
                alert(result.success);
                fetchMaterials();
                addForm.reset();
            } else if (result.error) {
                alert(result.error);
            }
        } catch (error) {
            console.error("Kļūda, pievienojot materiālu:", error);
        }
    });

    // Materiāla noņemšana
    removeForm.addEventListener("submit", async (e) => {
        e.preventDefault();

        if (!confirm("Vai tiešām vēlaties noņemt materiālu?")) return;

        const formData = new FormData(removeForm);
        const removeData = Object.fromEntries(formData.entries());

        try {
            const response = await fetch("../php/material-count.php?action=remove", {
                method: "POST",
                headers: { "Content-Type": "application/json" },
                body: JSON.stringify(removeData),
            });

            const result = await response.json();
            if (result.success) {
                alert(result.success);
                fetchMaterials();
                removeForm.reset();
            } else if (result.error) {
                alert(result.error);
            }
        } catch (error) {
            console.error("Kļūda, noņemot materiālu:", error);
        }
    });

    // Meklēšanas funkcionalitāte
    searchBar.addEventListener("input", (e) => {
        const searchTerm = e.target.value.toLowerCase();
        const rows = tableBody.querySelectorAll("tr");
        rows.forEach((row) => {
            const cells = Array.from(row.querySelectorAll("td"));
            const match = cells.some((cell) => cell.textContent.toLowerCase().includes(searchTerm));
            row.style.display = match ? "" : "none";
        });
    });

    fetchMaterials();
});