document.addEventListener("DOMContentLoaded", loadFAQs);

// Funkcija, lai ielādētu FAQ datus
function loadFAQs() {
    fetch("../php/faq.php?action=read")
        .then(response => {
            if (!response.ok) {
                throw new Error(`HTTP kļūda! Statuss: ${response.status}`);
            }
            return response.json();
        })
        .then(data => {
            if (data.error) {
                console.error("Kļūda, iegūstot FAQ:", data.error);
                return;
            }
            const faqBody = document.getElementById("faq-body");
            faqBody.innerHTML = "";
            data.forEach(faq => {
                const row = document.createElement("tr");

                const questionCell = document.createElement("td");
                questionCell.textContent = faq.question;
                row.appendChild(questionCell);

                const answerCell = document.createElement("td");
                answerCell.textContent = faq.answer;
                row.appendChild(answerCell);

                const optionsCell = document.createElement("td");

                const editButton = document.createElement("button");
                editButton.textContent = "Rediģēt";
                editButton.onclick = () => editFAQ(faq.id, faq.question, faq.answer);

                const deleteButton = document.createElement("button");
                deleteButton.textContent = "Dzēst";
                deleteButton.onclick = () => deleteFAQ(faq.id);

                optionsCell.appendChild(editButton);
                optionsCell.appendChild(deleteButton);
                row.appendChild(optionsCell);

                faqBody.appendChild(row);
            });
        })
        .catch(error => console.error("Kļūda, iegūstot FAQ:", error));
}

// Funkcija, lai pievienotu jaunu jautājumu un atbildi
function addNewFAQ() {
    const question = prompt("Ievadiet savu jautājumu:");
    const answer = prompt("Ievadiet savu atbildi:");
    if (question && answer) {
        fetch("../php/faq.php?action=create", {
            method: "POST",
            headers: { "Content-Type": "application/json" },
            body: JSON.stringify({ question, answer })
        })
            .then(response => {
                if (!response.ok) {
                    throw new Error(`HTTP kļūda! Statuss: ${response.status}`);
                }
                return response.json();
            })
            .then(data => {
                if (data.success) {
                    loadFAQs();
                } else {
                    console.error("Kļūda, pievienojot FAQ:", data.error);
                }
            })
            .catch(error => console.error("Kļūda, pievienojot FAQ:", error));
    }
}

// Funkcija, lai rediģētu esošu jautājumu un atbildi
function editFAQ(id, currentQuestion, currentAnswer) {
    const question = prompt("Rediģējiet jautājumu:", currentQuestion);
    const answer = prompt("Rediģējiet atbildi:", currentAnswer);

    if (question && answer) {
        fetch("../php/faq.php?action=update", {
            method: "POST",
            headers: { "Content-Type": "application/json" },
            body: JSON.stringify({ id, question, answer })
        })
            .then(response => {
                if (!response.ok) {
                    throw new Error(`HTTP kļūda! Statuss: ${response.status}`);
                }
                return response.json();
            })
            .then(data => {
                if (data.success) {
                    loadFAQs();
                } else {
                    console.error("Kļūda, rediģējot FAQ:", data.error || "Nezināma kļūda");
                }
            })
            .catch(error => console.error("Kļūda, rediģējot FAQ:", error));
    }
}

// Funkcija, lai dzēstu esošu jautājumu un atbildi
function deleteFAQ(id) {
    if (confirm("Vai tiešām vēlaties dzēst šo FAQ?")) {
        fetch(`../php/faq.php?action=delete&id=${id}`, {
            method: "GET" // GET metode tiek izmantota, jo serveris izmanto pieprasījuma parametrus
        })
            .then(response => {
                if (!response.ok) {
                    throw new Error(`HTTP kļūda! Statuss: ${response.status}`);
                }
                return response.json();
            })
            .then(data => {
                if (data.success) {
                    loadFAQs();
                } else {
                    console.error("Kļūda, dzēšot FAQ:", data.error || "Nezināma kļūda");
                }
            })
            .catch(error => console.error("Kļūda, dzēšot FAQ:", error));
    }
}