<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
include 'db.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Retrieve user inputs
    $email = $_POST['email'];
    $password = $_POST['password'];
    $confirmPassword = $_POST['confirm-password'];

    // Validate passwords match
    if ($password !== $confirmPassword) {
        echo "Passwords do not match! <a href='index.html'>Try again</a>";
        exit;
    }

    // Hash the password for security
    $hashedPassword = password_hash($password, PASSWORD_DEFAULT);

    // Insert the user into the database
    $sql = "INSERT INTO users (email, password) VALUES (?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ss", $email, $hashedPassword);

    if ($stmt->execute()) {
        // Redirect to the homepage on success
        header("Location: homepage.html");
        exit;
    } else {
        echo "Error: " . $stmt->error . "<br><a href='index.html'>Try again</a>";
    }

    // Close the statement and connection
    $stmt->close();
    $conn->close();
}
?>
