<?php
session_start();
header("Content-Type: application/json");
include 'db.php'; // Include your database connection

// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Check if the user is logged in
if (!isset($_SESSION['user_id'])) {
    echo json_encode(["status" => "error", "message" => "User not logged in"]);
    exit();
}

$userId = $_SESSION['user_id']; // Get the logged-in user ID

// Fetch elements from saved_elements table by user ID
$sql = "SELECT name FROM saved_elements WHERE users_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $userId);
$stmt->execute();
$result = $stmt->get_result();

$elements = [];
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $elements[] = $row; // Add element to the array
    }
}

echo json_encode($elements); // Return as JSON
$stmt->close();
$conn->close();
?>
