<?php 
session_start();
include 'db.php';

// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Check if the user is logged in
if (!isset($_SESSION['user_id'])) {
    echo json_encode(["status" => "error", "message" => "User not logged in"]);
    exit();
}

$userId = $_SESSION['user_id'];

// Basic elements to always include
$basicElements = [
    ["name" => "🔥 uguns"],
    ["name" => "💧 ūdens"],
    ["name" => "🌎 zeme"],
    ["name" => "💨 gaiss"]
];

// Fetch elements associated with the current user
$sql = "SELECT name FROM elements WHERE users_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $userId);
$stmt->execute();
$result = $stmt->get_result();

$userElements = [];
if ($result->num_rows > 0) {
    // Add user-specific elements to the array
    while ($row = $result->fetch_assoc()) {
        $userElements[] = $row;
    }
}

// Merge basic elements with user-specific elements
$elements = array_merge($basicElements, $userElements);

// Output elements as JSON
echo json_encode($elements);

$conn->close();
?>
