document.getElementById("registerBtn").addEventListener("click", function () {
    let isValid = true;

    // Ievades lauki
    const emailInput = document.getElementById("email");
    const phoneInput = document.getElementById("phone");
    const passwordInput = document.getElementById("password");
    const confirmPasswordInput = document.getElementById("confirmPassword");

    // Reset errors
    const inputs = [emailInput, phoneInput, passwordInput, confirmPasswordInput];
    inputs.forEach(input => {
        input.classList.remove("error");
        input.nextElementSibling.innerText = "";
    });

    // Email pārbaude
    const email = emailInput.value;
    const emailPattern = /^[^@]+@[^@]+\.[^@]{2,}$/;
    if (!emailPattern.test(email)) {
        emailInput.classList.add("error");
        emailInput.nextElementSibling.innerText = "Nederīga e-pasta adrese!";
        isValid = false;
    }

    // Tālruņa numura pārbaude
    const phone = phoneInput.value;
    if (!/^\d{8}$/.test(phone)) {
        phoneInput.classList.add("error");
        phoneInput.nextElementSibling.innerText = "Mobilā tālruņa numurs ir jābūt 8 ciparus garš!";
        isValid = false;
    }

    // Paroles pārbaude
    const password = passwordInput.value;
    const passwordPattern = /^(?=.*\d)(?=.*[A-Z]).{8,15}$/;
    if (!passwordPattern.test(password)) {
        passwordInput.classList.add("error");
        passwordInput.nextElementSibling.innerText = "Parolei jābūt vismaz 8 simbolu, saturēt ciparu un lielo burtu!";
        isValid = false;
    }

    // Paroles atkārtošana
    const confirmPassword = confirmPasswordInput.value;
    if (password !== confirmPassword) {
        confirmPasswordInput.classList.add("error");
        confirmPasswordInput.nextElementSibling.innerText = "Paroles nesakrīt!";
        isValid = false;
    }

    // Ja pārbaude veiksmīga
    if (isValid) {
        document.getElementById("message").innerText = "Veiksmīgi! Verifikācijas e-pasts ir nosūtīts.";
        // Izdzēst kļūdu kontūras, ja iepriekš bija
        inputs.forEach(input => input.classList.remove("error"));
        // Pāriet uz pieteikšanās logu
        setTimeout(() => {
            document.getElementById("message").innerText = "";
            window.location.href = "login.html";
        }, 2000);
    }
});
