document.addEventListener("DOMContentLoaded", () => {
    const elementsContainer = document.querySelector(".elements");
    const searchBar = document.querySelector(".search-bar");

    // Ielādē saglabātos elementus no datubāzes
    fetch("fetch_saved_elements.php")
        .then((response) => response.json())
        .then((elements) => {
            elementsContainer.innerHTML = ""; // Notīra esošo saturu
            elements.forEach((element) => {
                const elementItem = document.createElement("div");
                elementItem.classList.add("element-item");
                elementItem.textContent = element.name; // Pieņemot, ka `name` ir kolonna tabulā `saved_elements`
                elementsContainer.appendChild(elementItem);
            });
        })
        .catch((error) => console.error("Kļūda, ielādējot bibliotēkas elementus:", error));

    // Apstrādā meklēšanas joslas ievadi
    searchBar.addEventListener("input", (event) => {
        const query = event.target.value.toLowerCase();
        const elementItems = elementsContainer.querySelectorAll(".element-item");

        elementItems.forEach((item) => {
            const itemText = item.textContent.toLowerCase();
            item.style.display = itemText.includes(query) ? "" : "none";
        });
    });
});

function goBack() {
    window.location.href = 'homepage.html'; // Pāradresē uz sākumlapu
}
