<?php
session_start();
include 'db.php'; // Pievieno datubāzes savienojumu

// Iespējo kļūdu ziņošanu atkļūdošanai
error_reporting(E_ALL);
ini_set('display_errors', 1);

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Pārbauda, vai lietotājs ir pieteicies
    if (!isset($_SESSION['user_id'])) {
        echo json_encode(["status" => "error", "message" => "User not logged in"]);
        exit();
    }

    $userId = $_SESSION['user_id']; // Lietotāja ID
    $elementName = $_POST['name']; // Iegūst elementa nosaukumu

    // Ievieto elementu tabulā `saved_elements` kopā ar lietotāja ID
    $sql = "INSERT INTO saved_elements (name, users_id) VALUES (?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("si", $elementName, $userId);

    if ($stmt->execute()) {
        echo json_encode(["status" => "success", "message" => "Element saved successfully!"]);
    } else {
        echo json_encode(["status" => "error", "message" => "Failed to save element."]);
    }

    // Aizver paziņojumu un savienojumu ar datubāzi
    $stmt->close();
    $conn->close();
} else {
    echo json_encode(["status" => "error", "message" => "Invalid request method."]);
}
?>
