<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
include 'db.php'; // Pievieno datubāzes savienojumu

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Iegūst lietotāja ievadītos datus
    $email = $_POST['email'];
    $password = $_POST['password'];
    $confirmPassword = $_POST['confirm-password'];

    // Pārbauda, vai paroles sakrīt
    if ($password !== $confirmPassword) {
        echo "Paroles nesakrīt! <a href='index.html'>Mēģiniet vēlreiz</a>";
        exit;
    }

    // Šifrē paroli drošībai
    $hashedPassword = password_hash($password, PASSWORD_DEFAULT);

    // Lietotāja datu ievietošana datubāzē
    $sql = "INSERT INTO users (email, password) VALUES (?, ?)";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("ss", $email, $hashedPassword);

    if ($stmt->execute()) {
        // Pāradresē uz sākumlapu pēc veiksmīgas reģistrācijas
        header("Location: homepage.html");
        exit;
    } else {
        echo "Kļūda: " . $stmt->error . "<br><a href='index.html'>Mēģiniet vēlreiz</a>";
    }

    // Aizver paziņojumu un savienojumu ar datubāzi
    $stmt->close();
    $conn->close();
}
?>
