<?php
session_start();
header("Content-Type: application/json");
include 'db.php'; // Pievieno datubāzes savienojumu

// Iespējo kļūdu ziņošanu atkļūdošanai
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Pārbauda, vai lietotājs ir pieteicies
if (!isset($_SESSION['user_id'])) {
    echo json_encode(["status" => "error", "message" => "User not logged in"]);
    exit();
}

$userId = $_SESSION['user_id']; // Lietotāja ID

// Iegūst saglabātos elementus no tabulas saved_elements pēc lietotāja ID
$sql = "SELECT name FROM saved_elements WHERE users_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $userId);
$stmt->execute();
$result = $stmt->get_result();

$elements = [];
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $elements[] = $row; // Pievieno elementu masīvam
    }
}

echo json_encode($elements); // Atgriež elementus JSON formātā
$stmt->close();
$conn->close();
?>
