<?php 
session_start();
include 'db.php';

// Iespējo kļūdu ziņošanu atkļūdošanai
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Pārbauda, vai lietotājs ir pieteicies
if (!isset($_SESSION['user_id'])) {
    echo json_encode(["status" => "error", "message" => "User not logged in"]);
    exit();
}

$userId = $_SESSION['user_id']; // Lietotāja ID

// Pamatelementi, kas vienmēr ir pieejami
$basicElements = [
    ["name" => "🔥 uguns"],
    ["name" => "💧 ūdens"],
    ["name" => "🌎 zeme"],
    ["name" => "💨 gaiss"]
];

// Iegūst lietotājam piesaistītos elementus no datubāzes
$sql = "SELECT name FROM elements WHERE users_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $userId);
$stmt->execute();
$result = $stmt->get_result();

$userElements = [];
if ($result->num_rows > 0) {
    // Pievieno lietotājspecifiskos elementus masīvam
    while ($row = $result->fetch_assoc()) {
        $userElements[] = $row;
    }
}

// Apvieno pamatelementus ar lietotāja elementiem
$elements = array_merge($basicElements, $userElements);

// Atgriež elementus JSON formātā
echo json_encode($elements);

$conn->close();
?>
