// Pievienojam 'submit' notikuma klausītāju reģistrācijas formai
document.getElementById('registrationForm').addEventListener('submit', function(event) {
    // Novērš formas standarta iesniegšanas darbību, lai varētu pārbaudīt ievadītos datus
    event.preventDefault();
    
    // Iegūst lietotāja ievadītās vērtības no e-pasta, paroles un telefona lauka
    let email = document.getElementById('email').value;
    let password = document.getElementById('password').value;
    let phone = document.getElementById('phone').value;
    
    // Pārbauda e-pasta derīgumu, izmantojot validateEmail funkciju
    if (!validateEmail(email)) {
        alert('Lūdzu ievadiet derīgu e-pasta adresi.');
        return; // Ja e-pasts nav derīgs, pārtrauc darbību
    }
    
    // Pārbauda, vai parole atbilst prasībām: 8-15 simboli, jābūt ciparam un lielajam burtam
    if (password.length < 8 || password.length > 15 || !/\d/.test(password) || !/[A-Z]/.test(password)) {
        alert('Parolei jābūt no 8-15 simboliem, jāietver cipars un lielais burts.');
        return; // Ja parole nav derīga, pārtrauc darbību
    }
    
    // Pārbauda, vai telefona numurs ir 8 cipari, izmantojot regulāro izteiksmi
    if (!/^\d{8}$/.test(phone)) {
        alert('Telefona numuram jābūt 8 cipariem.');
        return; // Ja telefona numurs nav derīgs, pārtrauc darbību
    }
    
    // Ja visi lauki ir derīgi, parāda paziņojumu par veiksmīgu reģistrāciju
    alert('Reģistrācija veiksmīga!');
    // Pāradresē lietotāju uz pieteikšanās lapu
    window.location.href = 'login.html';
});

// Funkcija e-pasta formāta pārbaudei, izmantojot regulāro izteiksmi
function validateEmail(email) {
    const re = /\S+@\S+\.\S+/; // Regulārā izteiksme e-pasta formāta pārbaudei
    return re.test(email); // Atgriež 'true', ja e-pasta formāts ir pareizs, citādi 'false'
}
