function toggleForm(formId) {
    const registrationForm = document.getElementById('registration');
    const loginForm = document.getElementById('login');

    // Rāda vai paslēpj reģistrācijas un pieteikšanās formu atkarībā no izvēlētās formas
    registrationForm.style.display = formId === 'registration' ? 'block' : 'none';
    loginForm.style.display = formId === 'login' ? 'block' : 'none';
}

function navigateToHome() {
    window.location.href = 'homepage.html'; // Pāradresē uz sākumlapu
}
document.addEventListener("DOMContentLoaded", () => {
    const registrationForm = document.querySelector("#registration form");
    const passwordInput = document.getElementById("password");
    const confirmPasswordInput = document.getElementById("confirm-password");

    const lengthRequirement = document.getElementById("length");
    const uppercaseRequirement = document.getElementById("uppercase");

    passwordInput.addEventListener("input", () => {
        const password = passwordInput.value;

        // Length requirement
        if (password.length >= 8) {
            lengthRequirement.classList.remove("invalid");
            lengthRequirement.classList.add("valid");
        } else {
            lengthRequirement.classList.add("invalid");
            lengthRequirement.classList.remove("valid");
        }

        // Uppercase requirement
        if (/[A-Z]/.test(password)) {
            uppercaseRequirement.classList.remove("invalid");
            uppercaseRequirement.classList.add("valid");
        } else {
            uppercaseRequirement.classList.add("invalid");
            uppercaseRequirement.classList.remove("valid");
        }
    });

    registrationForm.addEventListener("submit", function (e) {
        const password = passwordInput.value;
        const confirmPassword = confirmPasswordInput.value;

        const isValidLength = password.length >= 8;
        const hasUppercase = /[A-Z]/.test(password);

        if (!isValidLength || !hasUppercase) {
            alert("Parole neatbilst prasībām.");
            e.preventDefault();
            return;
        }

        if (password !== confirmPassword) {
            alert("Paroles nesakrīt.");
            e.preventDefault();
        }
    });
});
