<?php 
session_start();
include 'db.php';

error_reporting(E_ALL);
ini_set('display_errors', 1);

if (!isset($_SESSION['user_id'])) {
    echo json_encode(["status" => "error", "message" => "User not logged in"]);
    exit();
}

$userId = $_SESSION['user_id'];

$sql = "SELECT name FROM elements WHERE users_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $userId);
$stmt->execute();
$result = $stmt->get_result();

$userElements = [];
while ($row = $result->fetch_assoc()) {
    $userElements[] = $row;
}

echo json_encode($userElements);

$conn->close();
?>
