document.addEventListener("DOMContentLoaded", () => {
    const elementsContainer = document.querySelector(".elements");
    const searchBar = document.querySelector(".search-bar");

    // Ielādē saglabātos elementus no servera
    fetch("fetch_library_elements.php")
        .then(response => response.json())
        .then(elements => {
            console.log("Library elements fetched:", elements);
            elements.forEach(element => {
                const el = document.createElement("div");
                el.classList.add("element-item");
                el.textContent = element.name;
                elementsContainer.appendChild(el);
            });
        })
        .catch(error => console.error("Kļūda, ielādējot bibliotēkas elementus:", error));

    // Meklēšana
    searchBar.addEventListener("input", (event) => {
        const query = event.target.value.toLowerCase();
        const elementItems = elementsContainer.querySelectorAll(".element-item");

        elementItems.forEach((item) => {
            const itemText = item.textContent.toLowerCase();
            item.style.display = itemText.includes(query) ? "" : "none";
        });
    });
});

function goBack() {
    window.location.href = 'homepage.html';
}
