<?php
session_start();
include 'db.php';

$response = ["hasSavedGame" => false];

if (isset($_SESSION['user_id'])) {
    $userId = $_SESSION['user_id'];
    $query = "SELECT * FROM saved_games WHERE user_id = ? LIMIT 1";
    $stmt = $conn->prepare($query);
    $stmt->bind_param("i", $userId);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $response["hasSavedGame"] = true;
    }
}

echo json_encode($response);
?>