document.getElementById('uploadButton').addEventListener('click', function() {
    document.getElementById('fileInput').click();
});

document.getElementById('fileInput').addEventListener('change', function(event) {
    const gallery = document.getElementById('imageGallery');

    for (const file of event.target.files) {
        const reader = new FileReader();

        reader.onload = function(e) {
            const img = document.createElement('img');
            img.src = e.target.result;

            const deleteButton = document.createElement('button');
            deleteButton.innerText = 'Delete';
            deleteButton.classList.add('delete-button');
            deleteButton.addEventListener('click', function() {
                gallery.removeChild(galleryItem);
            });

            const galleryItem = document.createElement('div');
            galleryItem.classList.add('gallery-item');
            galleryItem.appendChild(img);
            galleryItem.appendChild(deleteButton);

            gallery.appendChild(galleryItem);
        };

        reader.readAsDataURL(file);
    }
});