<?php
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $product_id = $_POST['product_id'];
    $quantity_to_takeout = $_POST['quantity_to_takeout'];

    // Validate the inputs
    if (!ctype_digit($product_id) || $product_id <= 0 || !is_numeric($quantity_to_takeout) || $quantity_to_takeout <= 0) {
        echo json_encode(array('error' => 'Invalid input.'));
        exit;
    }

    $servername = "localhost";
    $username = "root";
    $password = "";
    $dbname = "bigkarliic310";

    $conn = new mysqli($servername, $username, $password, $dbname);

    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }

    // Check if the product exists
    $checkProductSQL = "SELECT * FROM noliktava WHERE prece_id = ?";
    $stmt = $conn->prepare($checkProductSQL);
    $stmt->bind_param("i", $product_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 1) {
        $row = $result->fetch_assoc();
        $current_quantity = $row['daudzums'];

        if ($current_quantity >= $quantity_to_takeout) {
            $new_quantity = $current_quantity - $quantity_to_takeout;

            if ($new_quantity === 0) {
                // If the new quantity is zero, delete the product from the database
                $deleteSQL = "DELETE FROM noliktava WHERE prece_id = ?";
                $stmt->prepare($deleteSQL);
            } else {
                // Update the quantity in the database
                $updateSQL = "UPDATE noliktava SET daudzums = ? WHERE prece_id = ?";
                $stmt->prepare($updateSQL);
                $stmt->bind_param("ii", $new_quantity, $product_id);
            }

            if ($stmt->execute()) {
                // Insert the takeout record into the log
                $insertLogSQL = "INSERT INTO noliktava_log (prece_id, iznem_date, iznem_daudz) VALUES (?, NOW(), ?)";
                $stmt->prepare($insertLogSQL);
                $stmt->bind_param("ii", $product_id, $quantity_to_takeout);

                if (!$stmt->execute()) {
                    echo json_encode(array('error' => 'Error inserting data into log.'));
                    exit;
                }

                echo json_encode(array('success' => 'Product taken out successfully'));
            } else {
                echo json_encode(array('error' => 'Error updating record.'));
            }
        } else {
            echo json_encode(array('error' => 'Not enough quantity available for takeout.'));
        }
    } else {
        echo json_encode(array('error' => 'Product not found in the database.'));
    }

    $stmt->close();
    $conn->close();
} else {
    echo json_encode(array('error' => 'Invalid request method'));
}
?>
