document.addEventListener("DOMContentLoaded", function () {
    const takeoutForm = document.getElementById("takeoutForm");
    const productNameElement = document.getElementById("productName");
    const productQuantityElement = document.getElementById("productQuantity");

    // Fetch product details when the page loads
    fetchProductDetails();

    // Attach event listener to the form for handling form submission
    takeoutForm.addEventListener("submit", function (event) {
        event.preventDefault();
        takeoutProduct();
    });

    function fetchProductDetails() {
        const urlParams = new URLSearchParams(window.location.search);
        const productId = urlParams.get('product_id');

        fetch(`get_product_details.php?product_id=${productId}`)
            .then(response => response.json())
            .then(data => {
                if (data.error) {
                    console.error(data.error);
                } else {
                    productNameElement.textContent = data.name;
                    productQuantityElement.textContent = data.daudzums;
                }
            })
            .catch(error => console.error('Error fetching product details:', error));
    }

    function takeoutProduct() {
        const urlParams = new URLSearchParams(window.location.search);
        const productId = urlParams.get('product_id');
        const quantityToTakeout = document.getElementById("quantity_to_takeout").value;

        fetch("takeout.php", {
            method: "POST",
            headers: {
                "Content-Type": "application/x-www-form-urlencoded",
            },
            body: `product_id=${productId}&quantity_to_takeout=${quantityToTakeout}`,
        })
        .then(response => response.json())
        .then(data => {
            if (data.error) {
                console.error(data.error);
            } else {
                // Handle success, e.g., show a success message, redirect, etc.
                console.log("Product taken out successfully");
            }
        })
        .catch(error => console.error('Error taking out product:', error));
    }
});
