<?php
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "bigkarliic310";

$conn = new mysqli($servername, $username, $password, $dbname);
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

$product_data = array(); // Initialize an array to store product data

if (isset($_GET['product_id']) && is_numeric($_GET['product_id'])) {
    $product_id = $_GET['product_id'];

    $sql = "SELECT * FROM prece WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $product_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 1) {
        $product_data = $result->fetch_assoc();
    } else {
        // Handle the case when the product is not found
        $product_data['error'] = "Product not found in the database.";
    }

    $stmt->close();
}

$conn->close();
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="author" content="Karlis Malnieks">
    <meta name="group" content="310">
    <meta name="group_name" content="">
    <meta name="date_create" content="14.09.2023">
    <meta name="date_modify" content="20.09.2023">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Product Details</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background-color: #f4f4f4;
            margin: 0;
            padding: 0;
        }
        .container {
            max-width: 800px;
            margin: 20px auto;
            background-color: #fff;
            padding: 20px;
            box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
        }
        h2 {
            color: #007BFF;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            padding: 12px;
            text-align: left;
            border-bottom: 1px solid #ddd;
        }
        th {
            background-color: #f2f2f2;
        }
        .back-button {
            background-color: #dc3545;
            color: #fff;
            border: none;
            border-radius: 5px;
            padding: 10px 20px;
            cursor: pointer;
            text-decoration: none;
        }
        .back-button:hover {
            background-color: #c82333;
        }
    </style>
</head>
<body>
    <?php if (!empty($product_data)): ?>
        <?php if (isset($product_data['error'])): ?>
            <p><?php echo $product_data['error']; ?></p>
        <?php else: ?>
            <h2>Product Details</h2>
            <table>
                <tr>
                    <th>ID</th>
                    <th>Name</th>
                    <th>Serial</th>
                    <th>Inner Code</th>
                    <!-- Add more fields as needed -->
                </tr>
                <tr>
                    <td><?php echo $product_data['id']; ?></td>
                    <td><?php echo $product_data['name']; ?></td>
                    <td><?php echo $product_data['serial']; ?></td>
                    <td><?php echo $product_data['inner']; ?></td>
                    <!-- Add more fields as needed -->
                </tr>
            </table>
<button onclick="addProduct()">Add Product</button>

            <script>
                function addProduct() {
                    // Redirect to prece_reg.html with the product name and inner code pre-filled
                    var productName = '<?php echo addslashes($product_data['name']); ?>';
                    var innerCode = '<?php echo addslashes($product_data['inner']); ?>';

                    window.location.href = 'prece_reg.html?name=' + encodeURIComponent(productName) + '&iek_kod=' + encodeURIComponent(innerCode);
                }
            </script>
        <?php endif; ?>
    <?php endif; ?>
</body>
</html>
