document.addEventListener("DOMContentLoaded", function () {
    const GoBackButton = document.getElementById("GoBackButton");

    GoBackButton.addEventListener("click", function () {
        window.location.href = "landing_page.html";
    });

    // Fetch log entries and populate the table
    fetchLogEntries();
	
});

function fetchLogEntries() {
    const logTableBody = document.getElementById("logTableBody");

    fetch("get_log_entries.php")
        .then(response => response.json())
        .then(logEntries => {
            if (logEntries.length > 0) {
                logEntries.forEach(logEntry => {
                    const row = document.createElement("tr");
                    row.innerHTML = `
                        <td>${logEntry.name}</td>
                        <td>${logEntry.iznem_date}</td>
                        <td>${logEntry.iznem_daudz}</td>
                        <td><button class='delete-button' data-log-id='${logEntry.log_id}'>Delete</button></td>
                    `;
                    logTableBody.appendChild(row);
                });
            } else {
                logTableBody.innerHTML = "<tr><td colspan='4'>No log entries found</td></tr>";
            }

            // Add event listeners to delete buttons
            const deleteButtons = document.querySelectorAll('.delete-button');
            deleteButtons.forEach(button => {
                button.addEventListener('click', function () {
                    const logId = this.dataset.logId;
                    handleDelete(logId);
                });
            });
        })
        .catch(error => {
            console.error("Error fetching log entries:", error);
            alert("An error occurred while fetching log entries. Please try again.");
        });
}

function handleDelete(logId) {
    fetch("delete_log_entry.php", {
        method: "POST",
        body: JSON.stringify({ logId: logId }),
        headers: {
            "Content-Type": "application/json"
        }
    })
    .then(response => response.text())
    .then(data => {
        // Optionally, you can display a message or perform other actions after deletion
        console.log(data);
        
        // Fetch and update the log entries
        fetchLogEntries();
    });
	location.reload();
}
