document.addEventListener("DOMContentLoaded", function () {
    const addProductButton = document.getElementById("addProductButton");
    const LogButton = document.getElementById("LogButton");

    addProductButton.addEventListener("click", function() {
        window.location.href = "prece_reg.html";
    });

    LogButton.addEventListener("click", function() {
        window.location.href = "log.html";
    });

    document.getElementById("toggleButtons").addEventListener("click", function () {
        var buttonsToToggle = document.querySelectorAll(".action-button");
        for (var i = 0; i < buttonsToToggle.length; i++) {
            buttonsToToggle[i].classList.toggle("hidden");
        }
    });

    const tbody = document.querySelector('#productTable tbody');
    const popupContainer = document.getElementById('popupContainer');
    const popupContent = document.getElementById('popupContent');
    const closePopupButton = document.getElementById('closePopup');
    const searchInput = document.querySelector('.search-bar');
    let searchTimeout;

    // Function to open the popup with product details
    function openPopup(productId) {
        fetch(`get_product_details.php?product_id=${productId}`)
            .then(response => response.json())
            .then(data => {
                if (data.error) {
                    popupContent.innerHTML = `<p>${data.error}</p>`;
                } else {
                    popupContent.innerHTML = `
                        <h3>Product Details</h3>
                        <p>Product Name: ${data.name}</p>
                        <p>Quantity: ${data.daudzums}</p>
                        <p>Price: ${data.price}</p>
                        <p>Iz_date: ${data.iz_date}</p>
                        <p>Pieg_date: ${data.pieg_date}</p>
                        <button class="delete-button" data-product-id="${productId}">Delete</button>
                        <button class="takeout-button" data-product-id="${productId}">Takeout</button>
                    `;
                }

                popupContainer.style.display = "flex";
                // Add event listeners for delete and takeout buttons in the popup
                const deleteButton = document.querySelector('.delete-button');
                const takeoutButton = document.querySelector('.takeout-button');

                deleteButton.addEventListener('click', function () {
                    // Redirect to delete_product.php with the product ID
                    window.location.href = `delete_product.php?product_id=${productId}`;
                });

                takeoutButton.addEventListener('click', function () {
				window.location.href = `takeout.html?product_id=${productId}`;
				});

            })
            .catch(error => console.error('Error fetching product details:', error));
    }

    // Function to filter table rows based on search input
    function filterTable(searchTerm) {
        const rows = tbody.querySelectorAll('tr[data-product-id]');
        searchTerm = searchTerm.toLowerCase();

        rows.forEach(row => {
            const productName = row.querySelector('td:first-child').textContent.toLowerCase();
            row.style.display = productName.includes(searchTerm) ? 'table-row' : 'none';
        });
    }

    // Event listener for search input changes with debounce
    searchInput.addEventListener('input', function () {
        clearTimeout(searchTimeout);

        searchTimeout = setTimeout(function () {
            const searchTerm = searchInput.value.trim();
            filterTable(searchTerm);
        }, 300); // Adjust the delay as needed (in milliseconds)
    });

    // Attach event listeners to each row in the table
    tbody.addEventListener('click', function (event) {
        const clickedElement = event.target;

        // Check if the click is on a table row
        if (clickedElement.tagName === 'TD' && clickedElement.parentNode.tagName === 'TR') {
            const productId = clickedElement.parentNode.getAttribute('data-product-id');
            openPopup(productId);
        }
    });

    closePopupButton.addEventListener('click', function () {
        popupContainer.style.display = 'none';
    });

    // Fetch data from the server
    fetch('landing_page.php')
        .then(response => response.json())
        .then(data => {
            const tbody = document.querySelector('#productTable tbody');

            if (data.length > 0) {
                data.forEach(product => {
                    const row = document.createElement('tr');
                    row.setAttribute('data-product-id', product.id);

                    const nameCell = document.createElement('td');
                    nameCell.textContent = product.name;

                    const quantityCell = document.createElement('td');
                    quantityCell.textContent = product.daudzums;

                    row.appendChild(nameCell);
                    row.appendChild(quantityCell);

                    tbody.appendChild(row);
                });
            } else {
                const noProductsRow = document.createElement('tr');
                const noProductsCell = document.createElement('td');
                noProductsCell.setAttribute('colspan', '2');
                noProductsCell.textContent = 'No products found';

                noProductsRow.appendChild(noProductsCell);
                tbody.appendChild(noProductsRow);
            }
        })
        .catch(error => console.error('Error fetching data:', error));
});
