<?php
//Karlis Malnieks
if (isset($_GET['product_id'])) {
    $product_id = $_GET['product_id'];

    if (!ctype_digit($product_id) || $product_id <= 0) {
        $error_message = "Invalid product ID";
        echo json_encode(array('error' => $error_message));
        exit;
    }

    $servername = "localhost";
    $username = "root";
    $password = "";
    $dbname = "bigkarliic310";

    $conn = new mysqli($servername, $username, $password, $dbname);

    if ($conn->connect_error) {
        die("Connection failed: " . $conn->connect_error);
    }

    $sql = "SELECT prece.name, noliktava.daudzums, noliktava.price, noliktava.iz_date, noliktava.pieg_date
            FROM noliktava
            INNER JOIN prece ON noliktava.prece_id = prece.id
            WHERE prece.id = ?";
    
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $product_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();

        $product_details = array(
            'name' => $row['name'],
            'daudzums' => $row['daudzums'],
            'price' => $row['price'],
            'iz_date' => $row['iz_date'],
            'pieg_date' => $row['pieg_date'] 
        );

        $stmt->close();
        $conn->close();

        echo json_encode($product_details);
    } else {
        $error_message = "Product not found";
        echo json_encode(array('error' => $error_message));
    }
} else {
    $error_message = "Product ID is missing";
    echo json_encode(array('error' => $error_message));
}
?>
