<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="author" content="Karlis Malnieks">
    <meta name="group" content="310">
    <meta name="group_name" content="">
    <meta name="date_create" content="14.09.2023">
    <meta name="date_modify" content="20.09.2023">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
	<script src="https://cdn.jsdelivr.net/npm/quagga@0.12.1/dist/quagga.min.js"></script>
    <title>Barcode Scanner</title>
</head>
<body>
    <h1>Barcode Scanners</h1>
    <div id="scanner"></div>
    <p id="result"></p>

    <script>
    Quagga.init({
        inputStream: {
            name: 'Live',
            type: 'LiveStream',
            target: document.querySelector('#scanner'),
        },
        decoder: {
            readers: ['ean_reader', 'upc_reader'],
        },
    }, function (err) {
        if (err) {
            console.error(err);
            return;
        }
        console.log('QuaggaJS initialized.');

        Quagga.start();
    });

    Quagga.onDetected(function (data) {
        const scannedData = data.codeResult.code;
        document.getElementById('result').textContent = scannedData;

        sendDataToServer(scannedData);
    });

    function sendDataToServer(data) {
        fetch('process_scanned_data.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify({ data: data }),
        })
        .then(response => response.json())
        .then(responseData => {
            console.log(responseData);
            if (responseData.success && responseData.action === 'redirect') {
                window.location.href = 'reg_rem.php?barcode=' + encodeURIComponent(data);
            }
            else if (responseData.success && responseData.action === 'redirect_register') {
                window.location.href = 'bar_reg.php?barcode=' + encodeURIComponent(data);
            }
        })
        .catch(error => {
            console.error('Error:', error);
        });
    }
    </script>
</body>
</html>
