<?php
$barcode = isset($_GET['barcode']) ? $_GET['barcode'] : '';
$inner = $barcode;

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="author" content="Karlis Malnieks">
    <meta name="group" content="310">
    <meta name="group_name" content="">
    <meta name="date_create" content="14.09.2023">
    <meta name="date_modify" content="20.09.2023">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Register Product</title>
</head>
<body>

    <h1>Register Product</h1>

    <form id="registerForm" method="POST" action="bar_reg.php">
        <div>
            <label for="barcode">Barcode:</label>
            <input type="text" id="barcode" name="barcode" value="<?php echo $barcode; ?>" readonly>
        </div>
        <div>
            <label for="inner">Inner:</label>
            <input type="text" id="inner" name="inner" value="<?php echo $inner; ?>" readonly>
        </div>
        <div>
            <label for="name">Name:</label>
            <input type="text" id="name" name="Nos" placeholder="Product Name">
        </div>
        <div>
            <label for="ser_nr">Serial Number:</label>
            <input type="text" id="ser_nr" name="ser_nr" placeholder="Serial Number">
        </div>
        <div>
            <label for="ar_kod">Outer QR Code/Barcode:</label>
            <input type="text" id="ar_kod" name="ar_kod" placeholder="Outer QR Code/Barcode">
        </div>
        <div>
            <label for="pieg_date">Delivery Date:</label>
            <input type="date" id="pieg_date" name="pieg_date">
        </div>
        <div>
            <label for="daudz">Quantity:</label>
            <input type="number" id="daudz" name="daudz" placeholder="Quantity">
        </div>
        <div>
            <label for="merv">Measurement Unit:</label>
            <input type="text" id="merv" name="merv" placeholder="Measurement Unit">
        </div>
        <div>
            <label for="cena">Price:</label>
            <input type="text" id="cena" name="cena" placeholder="Price">
        </div>
        <div>
            <button type="submit">Register</button>
        </div>
    </form>

<?php
$servername = "localhost";
$username = "root";
$password = "";
$dbname = "bigkarliic310";

$conn = new mysqli($servername, $username, $password, $dbname);
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $Nos = $_POST["Nos"];
    $ser_nr = $_POST["ser_nr"];
    $ar_kod = $_POST["inner"];
    $pieg_date = $_POST["pieg_date"];
    $cena = $_POST["cena"];
    $daudz = $_POST["daudz"];
    $mervieniba = $_POST["merv"];

    if (empty($ar_kod)) {
        $ar_kod = generateUniqueBarcode($Nos, $pieg_date);
    }

    $iek_kod = generateUniqueBarcode($Nos, $pieg_date);


    $insertPreceSQL = "INSERT INTO prece (name, serial, `inner`, `outer`) VALUES (?, ?, ?, ?)";
    $stmt = $conn->prepare($insertPreceSQL);

    if ($stmt === false) {
        die("Error in SQL statement for inserting prece: " . $conn->error);
    }

    $stmt->bind_param("siss", $Nos, $ser_nr, $iek_kod, $ar_kod);

    if (!$stmt->execute()) {
        echo "Error inserting data into 'prece' table: " . $stmt->error;
        $stmt->close();
        $conn->close();
        exit();
    }

    $prece_id = $stmt->insert_id;
    $stmt->close();

    $insertNoliktavaSQL = "INSERT INTO noliktava (pieg_date, prece_id, price, daudzums, id_mer) VALUES (?, ?, ?, ?, ?)";
    $stmt = $conn->prepare($insertNoliktavaSQL);

    if ($stmt === false) {
        die("Error in SQL statement for inserting noliktava: " . $conn->error);
    }

    $stmt->bind_param("sidii", $pieg_date, $prece_id, $cena, $daudz, $merv_id);

    if ($stmt->execute()) {
        echo "Data inserted successfully into 'noliktava' table.";
    } else {
        echo "Error inserting data into 'noliktava' table: " . $stmt->error;
    }

    $stmt->close();

    $status_id = 2;
    $insertKlientsSQL = "INSERT INTO klients (id_status, id_uznemejs) VALUES (?, ?)";
    $stmt = $conn->prepare($insertKlientsSQL);

    if ($stmt === false) {
        die("Error in SQL statement for inserting klients: " . $conn->error);
    }

    $stmt->bind_param("ii", $status_id, $pieg_id);

    if ($stmt->execute()) {
        echo "Data inserted successfully into 'klients' table.";
    } else {
        echo "Error inserting data into 'klients' table: " . $stmt->error;
    }

    $stmt->close();

    $conn->close();
}

function generateUniqueBarcode($nosaukums, $Piegadatajs) {
    $uniqueKey = $nosaukums . $Piegadatajs;
    $iek_kod = md5($uniqueKey);
    return $iek_kod;
}
?>
</body>
</html>
