<?php
include "connect_ht.php";

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $product_id = $_POST['product_id'];
    $quantity_to_takeout = $_POST['quantity_to_takeout'];

    if (!ctype_digit($product_id) || $product_id <= 0 || !is_numeric($quantity_to_takeout) || $quantity_to_takeout <= 0) {
        echo json_encode(array('error' => 'Invalid input.'));
        exit;
    }

    $checkProductSQL = "SELECT daudzums FROM ht_noliktava WHERE prece_id = ?";
    $stmt = $conn->prepare($checkProductSQL);
    $stmt->bind_param("i", $product_id);
    $stmt->execute();
    $result = $stmt->get_result();

    if ($result->num_rows === 1) {
        $row = $result->fetch_assoc();
        $current_quantity = $row['daudzums'];

        if ($current_quantity >= $quantity_to_takeout) {
            $new_quantity = $current_quantity - $quantity_to_takeout;

            if ($new_quantity === 0) {
                $deleteSQL = "DELETE FROM ht_noliktava WHERE prece_id = ?";
                $stmt = $conn->prepare($deleteSQL);
                $stmt->bind_param("i", $product_id);
                $stmt->execute();
            } else {
                $updateSQL = "UPDATE ht_noliktava SET daudzums = ? WHERE prece_id = ?";
                $stmt = $conn->prepare($updateSQL);
                $stmt->bind_param("ii", $new_quantity, $product_id);
                $stmt->execute();
            }

            $insertLogSQL = "INSERT INTO ht_noliktava_log (prece_id, iznem_date, iznem_daudz) VALUES (?, NOW(), ?)";
            $stmt = $conn->prepare($insertLogSQL);
            $stmt->bind_param("ii", $product_id, $quantity_to_takeout);

            if (!$stmt->execute()) {
                echo json_encode(array('error' => 'Error inserting data into log.'));
                exit;
            }

            echo json_encode(array('success' => 'Product taken out successfully!'));
        } else {
            echo json_encode(array('error' => 'Not enough quantity available for takeout.'));
        }
    } else {
        echo json_encode(array('error' => 'Product not found in the database.'));
    }

    $stmt->close();
    $conn->close();
} else {
    echo json_encode(array('error' => 'Invalid request method'));
}
?>
