document.addEventListener("DOMContentLoaded", function () {
    const takeoutForm = document.getElementById("takeoutForm");
    const productNameElement = document.getElementById("productName");
    const productQuantityElement = document.getElementById("productQuantity");

    fetchProductDetails();

    takeoutForm.addEventListener("submit", function (event) {
        event.preventDefault();
        takeoutProduct();
    });
	const cancelButton = document.getElementById("cancelButton");
	cancelButton.addEventListener("click", function () {
    window.location.href = "landing_page.html";
	});

    function fetchProductDetails() {
        const urlParams = new URLSearchParams(window.location.search);
        const productId = urlParams.get('product_id');

        fetch(`get_product_details.php?product_id=${productId}`)
            .then(response => response.json())
            .then(data => {
                if (data.error) {
                    console.error(data.error);
                } else {
                    productNameElement.textContent = data.name;
                    productQuantityElement.textContent = data.daudzums;
                }
            })
            .catch(error => console.error('Error fetching product details:', error));
    }

    function takeoutProduct() {
    const urlParams = new URLSearchParams(window.location.search);
    const productId = urlParams.get('product_id');
    const quantityToTakeout = document.getElementById("quantity_to_takeout").value;

    fetch("takeout.php", {
        method: "POST",
        headers: {
            "Content-Type": "application/x-www-form-urlencoded",
        },
        body: `product_id=${productId}&quantity_to_takeout=${quantityToTakeout}`,
    })
    .then(response => response.json())
    .then(data => {
        if (data.error) {
            console.error(data.error);
        } else {
            if (data.new_quantity === 0) {
                window.location.href = `delete_product.php?product_id=${productId}`;
            } else {
                window.location.href = "landing_page.html";
            }
        }
    })
    .catch(error => console.error('Error taking out product:', error));
}
});
