document.addEventListener("DOMContentLoaded", function () {
    const GoBackButton = document.getElementById("GoBackButton");
    const searchInput = document.querySelector('.search-bar');

    GoBackButton.addEventListener("click", function () {
        window.location.href = "landing_page.html";
    });
    fetchLogEntries();
    let searchTimeout;
    searchInput.addEventListener('input', function () {
        clearTimeout(searchTimeout);

        searchTimeout = setTimeout(function () {
            const searchTerm = searchInput.value.trim();
            filterLogEntries(searchTerm);
        }, 300);
    });
});

function fetchLogEntries() {
    const logTableBody = document.getElementById("logTableBody");

    fetch("get_log_entries.php")
        .then(response => response.json())
        .then(logEntries => {
            if (logEntries.length > 0) {
                logTableBody.innerHTML = "";

                logEntries.forEach(logEntry => {
                    const row = document.createElement("tr");
                    row.innerHTML = `
                        <td>${logEntry.name}</td>
                        <td>${logEntry.iznem_date}</td>
                        <td>${logEntry.iznem_daudz}</td>
                        <td><button class='delete-button' data-log-id='${logEntry.log_id}'>Delete</button></td>
                    `;
                    logTableBody.appendChild(row);
                });
            } else {
                logTableBody.innerHTML = "<tr><td colspan='4'>No log entries found</td></tr>";
            }
            const deleteButtons = document.querySelectorAll('.delete-button');
            deleteButtons.forEach(button => {
                button.addEventListener('click', function () {
                    const logId = this.dataset.logId;
                    handleDelete(logId);
                });
            });
        })
}
function filterLogEntries(searchTerm) {
    const logTableBody = document.getElementById("logTableBody");
    const rows = logTableBody.querySelectorAll('tr');

    searchTerm = searchTerm.toLowerCase();

    rows.forEach(row => {
        const logName = row.querySelector('td:first-child').textContent.toLowerCase();
        row.style.display = logName.includes(searchTerm) ? 'table-row' : 'none';
    });
}

function handleDelete(logId) {
    fetch("delete_log_entries.php", {
        method: "POST",
        body: JSON.stringify({ logId: logId }),
        headers: {
            "Content-Type": "application/json"
        }
    })
    .then(response => response.text())
    .then(data => {
        location.reload();
        console.log(data);
        fetchLogEntries();
    });
    location.reload();
}
