document.addEventListener("DOMContentLoaded", function () {
    const addProductButton = document.getElementById("addProductButton");
    const LogButton = document.getElementById("LogButton");

    addProductButton.addEventListener("click", function() {
        window.location.href = "prece_reg.html";
    });

    LogButton.addEventListener("click", function() {
        window.location.href = "log.html";
    });
const popupContainer = document.getElementById('popupContainer');
    popupContainer.addEventListener('click', function (event) {
        if (event.target === popupContainer) {
            popupContainer.style.display = 'none';
        }
    });
    const tbody = document.querySelector('#productTable tbody');
    const popupContent = document.getElementById('popupContent');
    const searchInput = document.querySelector('.search-bar');
    let searchTimeout;
    function openPopup(productId) {
        fetch(`get_product_details.php?product_id=${productId}`)
            .then(response => response.json())
            .then(data => {
                if (data.error) {
                    popupContent.innerHTML = `<p>${data.error}</p>`;
                } else {
                    popupContent.innerHTML = `
                        <h3>Product Details</h3>
                        <p>Product Name: ${data.name}</p>
                        <p>Quantity: ${data.daudzums} ${data.mervieniba}</p>
                        <p>Price: ${data.price} €</p>
                        <p>Piegades datums: ${data.pieg_date}</p>
                        <button class="delete-button" data-product-id="${productId}" style="background-color: #5D001E; color: white; padding: 10px 20px; border: none; border-radius: 5px; cursor: pointer; margin-right: 10px;">Delete</button>
                    <button class="takeout-button" data-product-id="${productId}" style="background-color: #5D001E; color: white; padding: 10px 20px; border: none; border-radius: 5px; cursor: pointer; margin-right: 10px;">Takeout</button>
                `;
                }
                popupContainer.style.display = "flex";
                const deleteButton = document.querySelector('.delete-button');
                const takeoutButton = document.querySelector('.takeout-button');
                deleteButton.addEventListener('click', function () {
                    window.location.href = `delete_product.php?product_id=${productId}`;
                });
                takeoutButton.addEventListener('click', function () {
				window.location.href = `takeout.html?product_id=${productId}`;
				});

            })
            .catch(error => console.error('Error fetching product details:', error));
    }
    function filterTable(searchTerm) {
        const rows = tbody.querySelectorAll('tr[data-product-id]');
        searchTerm = searchTerm.toLowerCase();

        rows.forEach(row => {
            const productName = row.querySelector('td:first-child').textContent.toLowerCase();
            row.style.display = productName.includes(searchTerm) ? 'table-row' : 'none';
        });
    }
    searchInput.addEventListener('input', function () {
        clearTimeout(searchTimeout);
        searchTimeout = setTimeout(function () {
            const searchTerm = searchInput.value.trim();
            filterTable(searchTerm);
        }, 300);
    });
    tbody.addEventListener('click', function (event) {
        const clickedElement = event.target;
        if (clickedElement.tagName === 'TD' && clickedElement.parentNode.tagName === 'TR') {
            const productId = clickedElement.parentNode.getAttribute('data-product-id');
            openPopup(productId);
        }
    });
    fetch('landing_page.php')
        .then(response => response.json())
        .then(data => {
            const tbody = document.querySelector('#productTable tbody');

            if (data.length > 0) {
                data.forEach(product => {
                    const row = document.createElement('tr');
                    row.setAttribute('data-product-id', product.id);

                    const nameCell = document.createElement('td');
                    nameCell.textContent = product.name;

                    const quantityCell = document.createElement('td');
                    quantityCell.textContent = product.daudzums;

                    row.appendChild(nameCell);
                    row.appendChild(quantityCell);

                    tbody.appendChild(row);
                });
            } else {
                const noProductsRow = document.createElement('tr');
                const noProductsCell = document.createElement('td');
                noProductsCell.setAttribute('colspan', '2');
                noProductsCell.textContent = 'No products found';

                noProductsRow.appendChild(noProductsCell);
                tbody.appendChild(noProductsRow);
            }
        })
        .catch(error => console.error('Error fetching data:', error));
});
