<?php
//Karlis Malnieks
    include "connect_ht.php";
if (isset($_GET['product_id'])) {
    $product_id = $_GET['product_id'];
    if (!ctype_digit($product_id) || $product_id <= 0) {
        $error_message = "Invalid product ID";
        echo json_encode(array('error' => $error_message));
        exit;
    }
    $sql = "SELECT ht_prece.name, ht_noliktava.daudzums, ht_noliktava.price, ht_mervienibas.mervieniba, ht_noliktava.pieg_date
        FROM ht_noliktava
        INNER JOIN ht_prece ON ht_noliktava.prece_id = ht_prece.id
        INNER JOIN ht_mervienibas ON ht_noliktava.id_mer = ht_mervienibas.id
        WHERE ht_prece.id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $product_id);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result->num_rows > 0) {
        $row = $result->fetch_assoc();
        $product_details = array(
            'name' => $row['name'],
            'daudzums' => $row['daudzums'],
            'price' => $row['price'],
            'pieg_date' => $row['pieg_date'] ,
			'mervieniba' => $row['mervieniba']
        );
        $stmt->close();
        $conn->close();

        echo json_encode($product_details);
    } else {
        $error_message = "Product not found";
        echo json_encode(array('error' => $error_message));
    }
} else {
    $error_message = "Product ID is missing";
    echo json_encode(array('error' => $error_message));
}
?>
