<?php
// Karlis Malnieks
include "connect_ht.php";

if (isset($_GET['product_id'])) {
    $product_id = $_GET['product_id'];

    if (!ctype_digit($product_id) || $product_id <= 0) {
        echo "Invalid product ID";
        exit;
    }

    $sql = "DELETE FROM ht_noliktava WHERE prece_id = ?";
    
    $stmt = $conn->prepare($sql);

    if (!$stmt) {
        die("Error preparing statement: " . $conn->error);
    }

    $stmt->bind_param("i", $product_id);

    if ($stmt->execute()) {
        $stmt->close();
        $conn->close();
        header("Location: landing_page.html");
        exit;
    } else {
        $stmt->close();
        $conn->close();
        die("Error deleting record: " . $stmt->error);
    }
} else {
    echo "Product ID not set";
}
?>
