<?php
include "connect_ht.php";

$inputData = json_decode(file_get_contents("php://input"), true);

if (isset($inputData['id'])) {
    $productId = $inputData['id'];
    
    $sql = "DELETE FROM ht_prece WHERE id = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("i", $productId);

    if ($stmt->execute()) {
        header('Content-Type: application/json');
        echo json_encode(['success' => true, 'message' => 'Product deleted successfully']);
    } else {
        header('Content-Type: application/json');
        echo json_encode(['success' => false, 'message' => 'Error deleting product']);
    }

    $stmt->close();
} else {
    header('Content-Type: application/json');
    echo json_encode(['success' => false, 'message' => 'Invalid input']);
}
?>
