document.addEventListener("DOMContentLoaded", function () {
    const GoBackButton = document.getElementById("GoBackButton");

    GoBackButton.addEventListener("click", function () {
        window.location.href = "landing_page.html";
    });
});

Quagga.init({
        inputStream: {
            name: 'Live',
            type: 'LiveStream',
            target: document.querySelector('#scanner'),
        },
        decoder: {
            readers: ['ean_reader', 'upc_reader'],
        },
    }, function (err) {
        if (err) {
            console.error(err);
            return;
        }
        console.log('QuaggaJS initialized.');

        Quagga.start();
    });

    Quagga.onDetected(function (data) {
        const scannedData = data.codeResult.code;
        sendDataToServer(scannedData);
    });

    function sendDataToServer(data) {
        fetch('process_scanned_data.php', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify({ data: data }),
        })
        .then(response => response.json())
        .then(responseData => {
            console.log(responseData);
            if (responseData.success && responseData.action === 'redirect') {
                window.location.href = 'reg_rem.html?barcode=' + encodeURIComponent(data);
            }
            else if (responseData.success && responseData.action === 'redirect_register') {
                window.location.href = 'bar_reg.html?barcode=' + encodeURIComponent(data);
            }
        })
        .catch(error => {
            console.error('Error:', error);
        });
}