<?php
$barcode = isset($_GET['barcode']) ? $_GET['barcode'] : '';
$inner = $barcode;

include "connect_ht.php";

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $Nos = $_POST["Nos"];
    $ser_nr = $_POST["ser_nr"];
    $ar_kod = $_POST["barcode"];
    $pieg_date = $_POST["pieg_date"];
    $cena = $_POST["cena"];
    $daudz = $_POST["daudz"];
    $mervieniba = $_POST["merv"];

    if (empty($ar_kod)) {
        $ar_kod = generateUniqueBarcode($Nos, $pieg_date);
    }

    $iek_kod = generateUniqueBarcode($Nos, $pieg_date);

    $insertPreceSQL = "INSERT INTO ht_prece (name, serial, `inner`, `outer`) VALUES (?, ?, ?, ?)";
    $stmtPrece = $conn->prepare($insertPreceSQL);

    if ($stmtPrece === false) {
        die("Error in SQL statement for inserting prece: " . $conn->error);
    }

    $stmtPrece->bind_param("siss", $Nos, $ser_nr, $iek_kod, $ar_kod);

    if (!$stmtPrece->execute()) {
        echo "Error inserting data into 'prece' table: " . $stmtPrece->error;
        $stmtPrece->close();
        $conn->close();
        exit();
    }
    $prece_id = $stmtPrece->insert_id;
    $insertMervienibasSQL = "INSERT INTO ht_mervienibas (mervieniba) VALUES (?)";
    $stmtMervienibas = $conn->prepare($insertMervienibasSQL);

    if ($stmtMervienibas === false) {
        die("Error in SQL statement for inserting mervieniba: " . $conn->error);
    }

    $stmtMervienibas->bind_param("s", $mervieniba);

    if (!$stmtMervienibas->execute()) {
        echo "Error inserting data into 'mervienibas' table: " . $stmtMervienibas->error;
        $stmtPrece->close();
        $stmtMervienibas->close();
        $conn->close();
        exit();
    }

    $merv_id = $stmtMervienibas->insert_id;

    $insertNoliktavaSQL = "INSERT INTO ht_noliktava (pieg_date, prece_id, price, daudzums, id_mer) VALUES (?, ?, ?, ?, ?)";
    $stmtNoliktava = $conn->prepare($insertNoliktavaSQL);

    if ($stmtNoliktava === false) {
        die("Error in SQL statement for inserting noliktava: " . $conn->error);
    }

    $stmtNoliktava->bind_param("sidii", $pieg_date, $prece_id, $cena, $daudz, $merv_id);

    if ($stmtNoliktava->execute()) {
        header("Location: landing_page.html");
        exit;
    } else {
        echo "Error inserting data into 'noliktava' table: " . $stmtNoliktava->error;
    }

    $stmtPrece->close();
    $stmtMervienibas->close();
    $stmtNoliktava->close();
    $conn->close();
}

function generateUniqueBarcode($nosaukums, $Piegadatajs) {
    $uniqueKey = $nosaukums . $Piegadatajs;
    $iek_kod = md5($uniqueKey);
    return $iek_kod;
}
?>
