<?php
include "connect_ht.php";

$barcode = isset($_GET['barcode']) ? $_GET['barcode'] : '';

if ($barcode) {
    $sql = "SELECT * FROM ht_prece WHERE `outer` = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $barcode);
    $stmt->execute();
    $result = $stmt->get_result();
    $stmt->close();

    if ($result->num_rows > 0) {
        $productsData = $result->fetch_all(MYSQLI_ASSOC);

        header('Content-Type: application/json');
        echo json_encode($productsData);
    } else {
        header('Content-Type: application/json');
        echo json_encode(['error' => 'No products found']);
    }
} else {
    header('Content-Type: application/json');
    echo json_encode(['error' => 'No barcode provided']);
}
?>
