document.addEventListener("DOMContentLoaded", function () {
    const barcode = new URLSearchParams(window.location.search).get('barcode');
    const GoBackButton = document.getElementById("GoBackButton");

    GoBackButton.addEventListener("click", function () {
        window.location.href = `reg_rem.html?barcode=${barcode}`;
    });


    fetch(`bar_noliktava.php?barcode=${barcode}`)
        .then(response => response.json())
        .then(productsData => {
            const productTable = document.getElementById("productTable");

            if (productsData.length > 0) {
                const headerRow = productTable.insertRow();
                Object.keys(productsData[0]).forEach(key => {
                    const th = document.createElement("th");
                    th.textContent = key.charAt(0).toUpperCase() + key.slice(1);
                    headerRow.appendChild(th);
                });
                headerRow.insertCell().textContent = "Actions";

                productsData.forEach(product => {
                    const row = productTable.insertRow();
                    Object.values(product).forEach(value => {
                        const cell = row.insertCell();
                        cell.textContent = value;
                    });
                    const actionsCell = row.insertCell();
                    const registerButton = document.createElement("button");
                    registerButton.textContent = "Register";
                    registerButton.addEventListener("click", function () {
                        const additionalData = {
                            name: product.name,
                            serial: product.serial,
                        };

                        const queryString = Object.keys(additionalData)
                            .map(key => `${encodeURIComponent(key)}=${encodeURIComponent(additionalData[key])}`)
                            .join('&');

                        window.location.href = `bar_reg_register.html?barcode=${barcode}&${queryString}`;
                    });

                    const deleteButton = document.createElement("button");
                    deleteButton.textContent = "Delete";
                    deleteButton.addEventListener("click", function () {
                        const confirmDelete = confirm("Are you sure you want to delete?");
                        if (confirmDelete) {
                            deleteProduct(product.id);
                        }
                    });

                    actionsCell.appendChild(registerButton);
                    actionsCell.appendChild(deleteButton);
                });
            } else {
                const row = productTable.insertRow();
                const cell = row.insertCell();
                cell.colSpan = Object.keys(productsData[0]).length + 1;
                cell.textContent = "No products found";
            }
        })
        .catch(error => console.error('Error fetching product data:', error));

    function deleteProduct(productId) {
        fetch("delete_prece.php", {
            method: "POST",
            headers: {
                "Content-Type": "application/json",
            },
            body: JSON.stringify({ id: productId }),
        })
        .then(response => response.json())
        .then(data => {
            console.log(data);
            window.location.href = `bar_noliktava.html?barcode=${barcode}`;
            Exit();
        })
        .catch(error => console.error('Error deleting product:', error));
    }
});
