document.getElementById('loginForm').addEventListener('submit', function(event) {
    event.preventDefault();
    var username = document.getElementsByName('uname')[0].value; // Lietotāja vards
    document.getElementById('loginForm').classList.add('hidden'); // Paslēpj pieslēgšanās formu
    document.getElementById('clockPage').classList.remove('hidden'); // Parāda hronometru lapu.
    document.getElementById('userDisplay').innerText = 'Welcome, ' + username;
});

document.getElementById('save-settings').addEventListener('click', function() {
    var color = document.getElementById('color').value; 
    var font = document.getElementById('font').value;
    localStorage.setItem('stopwatchColor', color); // Saglabā izvēlētās krāsas un fontu uz lokālo krātuvi.
    localStorage.setItem('stopwatchFont', font); 
    applySettings(color, font);
});

// Uzlāde iepriekš saglabātās konfigurācijas no lokālās krātvues.
function loadSettings() {
    var color = localStorage.getItem('stopwatchColor') || '#ffffff'; 
    var font = localStorage.getItem('stopwatchFont') || "'Share Tech Mono', monospace";
    document.getElementById('color').value = color; 
    document.getElementById('font').value = font;
    applySettings(color, font);
}

function applySettings(color, font) {
    document.getElementById('minutes').style.color = color;
    document.getElementById('seconds').style.color = color;
    document.getElementById('tens').style.color = color;
    document.getElementById('minutes').style.fontFamily = font;
    document.getElementById('seconds').style.fontFamily = font;
    document.getElementById('tens').style.fontFamily = font;
}

document.addEventListener('DOMContentLoaded', loadSettings);

// Hronometru mainīgie
var Interval;
var tens = 0, seconds = 0, minutes = 0;

// Pogas
var buttonStart = document.getElementById('button-start');
var buttonStop = document.getElementById('button-stop');
var buttonReset = document.getElementById('button-reset');
var buttonLap = document.getElementById('button-lap');

var lapCounter = 0;

// Timers
function startTimer() {
    var appendTens = document.getElementById("tens");
    var appendSeconds = document.getElementById("seconds");
    var appendMinutes = document.getElementById("minutes");

    tens++; 
    if(tens <= 9){
        appendTens.innerHTML = "0" + tens;
    }
    if (tens > 9){
        appendTens.innerHTML = tens;
    } 
    if (tens > 99) {
        seconds++;
        appendSeconds.innerHTML = "0" + seconds;
        tens = 0;
        appendTens.innerHTML = "0" + 0;
    }
    if (seconds > 9){
        appendSeconds.innerHTML = seconds;
    }
    if (seconds > 59) {
        minutes++;
        appendMinutes.innerHTML = "0" + minutes;
        seconds = 0;
        appendSeconds.innerHTML = "0" + 0;
    }
    if (minutes > 9){
        appendMinutes.innerHTML = minutes;
    }
}

// Start, stop, restartēt un aplis pogu funkcionalitātes
buttonStart.onclick = function() {
    clearInterval(Interval);
    Interval = setInterval(startTimer, 10);
}
buttonStop.onclick = function() {
    clearInterval(Interval);
}
buttonReset.onclick = function() {
    clearInterval(Interval);
    tens = "00";
    seconds = "00";
    minutes = "00";
    document.getElementById("tens").innerHTML = tens;
    document.getElementById("seconds").innerHTML = seconds;
    document.getElementById("minutes").innerHTML = minutes;
    // Restartē hronometru apļa tabulu
    document.getElementById("table").innerHTML = `
        <tr>
            <th>Lap</th>
            <th>Time</th>
            <th>Date</th>
        </tr>`;
    lapCounter = 0;
}
buttonLap.onclick = function() {
    lapCounter++;
    var table = document.getElementById("table");
    var newRow = table.insertRow(); // Izveido jaunu tabulu
    var lapCell = newRow.insertCell(0); // Pieliek klāt cell
    var timeCell = newRow.insertCell(1);
    var dateCell = newRow.insertCell(2);
    
    lapCell.innerHTML = lapCounter;
    timeCell.innerHTML = `${minutes}:${seconds}:${tens}`;
    dateCell.innerHTML = new Date().toLocaleString();
}

// Saglabā tabulu uz faily.
document.getElementById('save-laps').onclick = function() {
    var table = document.getElementById("table");
    var rows = Array.from(table.rows).slice(1);
    var laps = rows.map(row => ({
        lap: row.cells[0].innerText,
        time: row.cells[1].innerText,
        date: row.cells[2].innerText
    }));
    var json = JSON.stringify(laps); // Parveido laps uz json
    var blob = new Blob([json], { type: "application/json" });
    var url = URL.createObjectURL(blob);
    var a = document.createElement('a');
    a.href = url;
    a.download = "laps.json";
    document.body.appendChild(a);
    a.click();
    document.body.removeChild(a);
}

document.getElementById('load-laps').onclick = function() {
    var fileInput = document.getElementById('fileUpload');
    fileInput.click();
}

document.getElementById('fileUpload').addEventListener('change', function(event) {
    var file = event.target.files[0];
    var reader = new FileReader();
    reader.onload = function(event) {
        var laps = JSON.parse(event.target.result);
        var table = document.getElementById("table");
        table.innerHTML = `
            <tr>
                <th>Lap</th>
                <th>Time</th>
                <th>Date</th>
            </tr>`;
        lapCounter = 0;
        laps.forEach(lap => {
            var newRow = table.insertRow();
            var lapCell = newRow.insertCell(0);
            var timeCell = newRow.insertCell(1);
            var dateCell = newRow.insertCell(2);

            lapCell.innerHTML = lap.lap;
            timeCell.innerHTML = lap.time;
            dateCell.innerHTML = lap.date;
            lapCounter++;
        });
    }
    reader.readAsText(file);
});
