document.addEventListener('DOMContentLoaded', function () {
    // Display user info
    document.getElementById('user-info').innerHTML = "User: Guest";

    // Sample tasks
    let tasks = [
        { category: "Work", task: "Finish report", inputDate: "2024-05-07", dueDate: "2024-05-10", completionDate: "", completed: false },
        { category: "Personal", task: "Buy groceries", inputDate: "2024-05-07", dueDate: "2024-05-08", completionDate: "", completed: false }
    ];

    // Display tasks
    displayTasks(tasks);

    // Function to display tasks
    function displayTasks(tasks) {
        let todoList = document.getElementById('todo-list');
        todoList.innerHTML = "";
        tasks.forEach(task => {
            let taskElement = document.createElement('div');
            taskElement.classList.add('todo-item');
            taskElement.innerHTML = `
                <h3>${task.task}</h3>
                <p>Category: ${task.category}</p>
                <p>Input Date: ${task.inputDate}</p>
                <p>Due Date: ${task.dueDate}</p>
                <p>Completion Date: ${task.completionDate}</p>
                <button onclick="editTask('${task.task}')">Edit</button>
                <button onclick="deleteTask('${task.task}')">Delete</button>
                <button onclick="markAsCompleted('${task.task}')">Mark as Completed</button>
            `;
            todoList.appendChild(taskElement);
        });
    }

    // Function to add task
    window.addTask = function () {
        let taskName = document.getElementById('task-name').value;
        let category = document.getElementById('category').value;
        let inputDate = document.getElementById('input-date').value;
        let dueDate = document.getElementById('due-date').value;
        if (taskName && category && inputDate && dueDate) {
            let newTask = {
                category: category,
                task: taskName,
                inputDate: inputDate,
                dueDate: dueDate,
                completionDate: "",
                completed: false
            };
            tasks.push(newTask);
            displayTasks(tasks);
            // Clear input fields
            document.getElementById('task-name').value = "";
            document.getElementById('category').value = "";
            document.getElementById('input-date').value = "";
            document.getElementById('due-date').value = "";
        } else {
            alert("Please fill in all fields");
        }
    }

    // Function to edit task
    window.editTask = function (taskName) {
        let taskIndex = tasks.findIndex(task => task.task === taskName);
        let newTaskName = prompt("Enter new task name:");
        tasks[taskIndex].task = newTaskName;
        displayTasks(tasks);
    }

    // Function to delete task
    window.deleteTask = function (taskName) {
        let confirmation = confirm("Are you sure you want to delete this task?");
        if (confirmation) {
            tasks = tasks.filter(task => task.task !== taskName);
            displayTasks(tasks);
        }
    }

    // Function to mark task as completed
    window.markAsCompleted = function (taskName) {
        let taskIndex = tasks.findIndex(task => task.task === taskName);
        tasks[taskIndex].completed = true;
        tasks[taskIndex].completionDate = new Date().toISOString().slice(0, 10);
        displayTasks(tasks);
    }
});
