
// Mainigie
let loggedInUser = null;
let intervalId;
let stopwatchIntervalId;
let stopwatchTime = 0;
let laps = [];
let actions = [];

// Login 
function login() {
    const username = document.getElementById('username').value;
    if (username) {
        loggedInUser = username;
        document.querySelector('.login-container').classList.add('d-none');
        document.querySelector('.clock-container').classList.remove('d-none');
        document.querySelector('.stopwatch-container').classList.remove('d-none');
        document.getElementById('user-info').innerText = `Sveicināti, ${username}!`;
        startClock();
    }
}

// Sāk pulksteni un viss pārējais
function startClock() {
    intervalId = setInterval(() => {
        const now = new Date();
        const hours = now.getHours().toString().padStart(2, '0');
        const minutes = now.getMinutes().toString().padStart(2, '0');
        const seconds = now.getSeconds().toString().padStart(2, '0');
        document.getElementById('time').innerText = `${hours}:${minutes}:${seconds}`;
        updateClockStyles();
        updateStopwatchStyles();
    }, 1000);
}

// Update pulkstena stili
function updateClockStyles() {
    const hoursColor = document.getElementById('hoursColor').value;
    const minutesColor = document.getElementById('minutesColor').value;
    const secondsColor = document.getElementById('secondsColor').value;
    const font = document.getElementById('fontSelect').value;

    const timeElement = document.getElementById('time');
    const [hours, minutes, seconds] = timeElement.innerText.split(':');
    timeElement.innerHTML = `<span style="color:${hoursColor};">${hours}</span>:<span style="color:${minutesColor};">${minutes}</span>:<span style="color:${secondsColor};">${seconds}</span>`;
    timeElement.style.fontFamily = font;
}
function updateClockSettings() {
    updateClockStyles();
}

// Sak hronometru
function startStopwatch() {
    stopwatchIntervalId = setInterval(() => {
        stopwatchTime += 1;
        document.getElementById('stopwatch').innerText = formatTime(stopwatchTime);
        updateStopwatchStyles();
    }, 1000);
    logAction('Sākts');
    toggleStartLapButton();
    toggleStopSaveButton(false);
}

// Hronometra stili tiek updated
function updateStopwatchStyles() {
    const hoursColor = document.getElementById('hoursColor').value;
    const minutesColor = document.getElementById('minutesColor').value;
    const secondsColor = document.getElementById('secondsColor').value;
    const font = document.getElementById('fontSelect').value;

    const stopwatchElement = document.getElementById('stopwatch');
    const [hours, minutes, seconds] = stopwatchElement.innerText.split(':');
    stopwatchElement.innerHTML = `<span style="color:${hoursColor};">${hours}</span>:<span style="color:${minutesColor};">${minutes}</span>:<span style="color:${secondsColor};">${seconds}</span>`;
    stopwatchElement.style.fontFamily = font;
}

// Lap poga
function lapStopwatch() {
    laps.push(stopwatchTime);
    logAction('Aplis');
    displayLaps();
}

// Pauzet poga
function pauseStopwatch() {
    clearInterval(stopwatchIntervalId);
    logAction('Pauze');
    document.getElementById('pause-btn').innerText = 'Atsākt';
    document.getElementById('pause-btn').onclick = resumeStopwatch;
}

// Atsākt poga
function resumeStopwatch() {
    startStopwatch();
    logAction('Atsākts');
    document.getElementById('pause-btn').innerText = 'Pauze';
    document.getElementById('pause-btn').onclick = pauseStopwatch;
}

// Stop poga
function stopStopwatch() {
    clearInterval(stopwatchIntervalId);
    laps.push(stopwatchTime);
    logAction('Stop');
    displayLaps();
    toggleStartLapButton(true);
    toggleStopSaveButton(true);
}

// Reset poga
function resetData() {
    stopwatchTime = 0;
    laps = [];
    actions = [];
    document.getElementById('stopwatch').innerText = formatTime(stopwatchTime);
    displayLaps();
    displayResults();
    document.getElementById('reset-btn').disabled = true;
}

// saglaba visas darbibas
function logAction(action) {
    const now = new Date();
    const time = now.getHours().toString().padStart(2, '0') + ':' +
                 now.getMinutes().toString().padStart(2, '0') + ':' +
                 now.getSeconds().toString().padStart(2, '0');
    actions.push({ action, time });
    displayResults();
}

// Izvada Darbibas
function displayResults() {
    const resultsDiv = document.getElementById('results');
    resultsDiv.innerHTML = '';
    actions.forEach((entry, index) => {
        const actionDiv = document.createElement('div');
        actionDiv.innerText = `${entry.action} pie ${entry.time}`;
        resultsDiv.appendChild(actionDiv);
    });
}

// Izvada apļu laikus
function displayLaps() {
    const lapsDiv = document.getElementById('laps');
    lapsDiv.innerHTML = '';
    laps.forEach((lap, index) => {
        const lapDiv = document.createElement('div');
        lapDiv.innerText = `Aplis ${index + 1}: ${formatTime(lap)}`;
        lapsDiv.appendChild(lapDiv);
    });
}

function formatTime(seconds) {
    const hrs = Math.floor(seconds / 3600).toString().padStart(2, '0');
    const mins = Math.floor((seconds % 3600) / 60).toString().padStart(2, '0');
    const secs = (seconds % 60).toString().padStart(2, '0');
    return `${hrs}:${mins}:${secs}`;
}

// Start un lap pogu maina
function toggleStartLapButton(isReset = false) {
    const startBtn = document.getElementById('start-btn');
    const lapBtn = document.getElementById('lap-btn');
    
    if (isReset) {
        startBtn.innerText = 'Sākt';
        startBtn.onclick = startStopwatch;
        startBtn.style.display = 'inline-block';
        lapBtn.style.display = 'none';
    } else {
        startBtn.style.display = 'none';
        lapBtn.style.display = 'inline-block';
    }
}

// Stop un save pogu maina
function toggleStopSaveButton(isStopped = false) {
    const stopBtn = document.getElementById('stop-btn');
    const saveBtn = document.getElementById('save-btn');
    
    if (isStopped) {
        stopBtn.style.display = 'none';
        saveBtn.style.display = 'inline-block';
    } else {
        stopBtn.style.display = 'inline-block';
        saveBtn.style.display = 'none';
    }
}

// Saglabā kā JSON (Tiek ieklauts pulkstena configuracija)
function saveData() {
    const data = {
        user: loggedInUser,
        clockSettings: {
            hoursColor: document.getElementById('hoursColor').value,
            minutesColor: document.getElementById('minutesColor').value,
            secondsColor: document.getElementById('secondsColor').value,
            font: document.getElementById('fontSelect').value
        },
        stopwatch: {
            laps: laps,
            actions: actions
        }
    };
    const json = JSON.stringify(data);

    const blob = new Blob([json], { type: 'application/json' });
    const url = URL.createObjectURL(blob);

    const a = document.createElement('a');
    a.href = url;
    a.download = `${loggedInUser}_config.json`; 
    a.click();
    URL.revokeObjectURL(url);
    toggleStopSaveButton(true);
    toggleStartLapButton(true);
}
