document.getElementById('form').addEventListener('submit', function(event) { //gaida kad tiks nosutiti dati
    event.preventDefault();

    const username = document.getElementById('username').value;
    if (username) {
        document.getElementById('login-form').style.display = 'none';
		document.getElementById('download-config-btn').style.display = 'inline-block';//samaina redzamibu vairakam pogam
        document.getElementById('username-container').style.display = 'inline-block';
        document.getElementById('clock').style.display = 'flex';
        document.getElementById('logged-in-user').textContent = `${username}`;
        startClock();//sāk pulksteni
        loadUserConfig(username);
    }
});

function loadUserConfig(username) {
    const hourFont = localStorage.getItem(`${username}_hour_font`);
    const hourColor = localStorage.getItem(`${username}_hour_color`);
    const minuteFont = localStorage.getItem(`${username}_minute_font`);//np lokalas atminas panem lietotaja elementu vertibas
    const minuteColor = localStorage.getItem(`${username}_minute_color`);
    const secondFont = localStorage.getItem(`${username}_second_font`);
    const secondColor = localStorage.getItem(`${username}_second_color`);

    if (hourFont && hourColor) {
        applyStyles(hourColor, hourFont, 'hour');
    }
    if (minuteFont && minuteColor) {
        applyStyles(minuteColor, minuteFont, 'minute');
    }
    if (secondFont && secondColor) {
        applyStyles(secondColor, secondFont, 'second');
    }
}


document.getElementById('logout-btn').addEventListener('click', function() {
	document.getElementById('download-config-btn').style.display = 'none';//izlogojas ara 
    document.getElementById('login-form').style.display = 'block';
    document.getElementById('username-container').style.display = 'none';
    document.getElementById('clock').style.display = 'none';
    document.getElementById('logged-in-user').textContent = '';
    clearInterval(chronoInterval);
    resetChronometerButtons();
    const username = document.getElementById('logged-in-user').textContent;
});
function applyStyles(color, font, clockPart) {
    const clockPartElement = document.getElementById(clockPart);//pec krasu un fontu izvelesanas un apply uzspiezsanas tiek uzlikti tie uz pulkstena
    if (clockPartElement) {
        clockPartElement.style.color = color;
        clockPartElement.style.fontFamily = font;
    }
}
function startClock() {
    function updateTime() {
        const hourElement = document.getElementById('hour');
        const minuteElement = document.getElementById('minute');//sākas pulkstenis
        const secondElement = document.getElementById('second');
        const now = new Date();
        const hours = now.getHours().toString().padStart(2, '0');
        const minutes = now.getMinutes().toString().padStart(2, '0');
        const seconds = now.getSeconds().toString().padStart(2, '0');
        hourElement.textContent = hours;
        minuteElement.textContent = minutes;
        secondElement.textContent = seconds;
    }
    updateTime();
    setInterval(updateTime, 1000);

    const username = document.getElementById('logged-in-user').textContent;
    const userConfig = JSON.parse(localStorage.getItem(`${username}_config`));
    if (userConfig) {
        applyStyles(userConfig.color, userConfig.font);
    }
}

let chronoInterval;
let chronoRunning = false;
let chronoStartTime;
let elapsedTime = 0;
let lastLapTime = 0;
let pauseTime = 0;
var click = 0;

document.getElementById('start-pause-btn').addEventListener('click', function() {
    click += 1;
    if (chronoRunning) {
        pauseChronometer();
    } else {
        startChronometer();
    }
});

document.getElementById('stop-btn').addEventListener('click', function() {
    stopChronometer();
});

document.getElementById('lap-btn').addEventListener('click', function() {
    recordLap();
});

document.getElementById('delete-log-btn').addEventListener('click', function() {
    deleteLog();
    resetChronometerButtons();
});

function startChronometer() {
    chronoStartTime = Date.now() - elapsedTime;
    chronoInterval = setInterval(updateChronometer, 1);
    chronoRunning = true;
    const totalTime = elapsedTime;
    document.getElementById('start-pause-btn').textContent = 'Pause';
    document.getElementById('action-log').style.display = 'inline-block';//sākas hronomets un tiek paraditas paris pogas
    document.getElementById('lap-btn').style.display = 'inline-block';
    document.getElementById('stop-btn').style.display = 'inline-block';
    const pauseInterval = Date.now() - pauseTime;
    const lapTime = pauseInterval;
    if (click == 1) {
        logAction('Start', totalTime);
    } else {
        logAction('Resume', lapTime, totalTime);//nodod vertibas lai tas ieliktu tabula
    }
    pauseTime = 0;
}

function pauseChronometer() {
    clearInterval(chronoInterval);
    pauseTime = Date.now();
    const totalTime = elapsedTime;
    const lapTime = elapsedTime - lastLapTime;//nopauzē hronometru
    chronoRunning = false;
    document.getElementById('start-pause-btn').textContent = 'Resume';
    logAction('Pause', 0, totalTime);
}

function stopChronometer() {
    clearInterval(chronoInterval);
    const totalTime = elapsedTime;
    const lapTime = elapsedTime - lastLapTime;
    elapsedTime = 0;
    lastLapTime = 0;
    chronoRunning = false;
    document.getElementById('chrono-time').textContent = formatTime(0);//apstādina hronometru  un tabulā piefixē laikus
    document.getElementById('start-pause-btn').textContent = 'Start';
    document.getElementById('laps').innerHTML = '';
    document.getElementById('stop-btn').style.display = 'none';
    document.getElementById('lap-btn').style.display = 'none';
    document.getElementById('start-pause-btn').style.display = 'none';
    document.getElementById('save-log-btn').style.display = 'inline-block';
    document.getElementById('delete-log-btn').style.display = 'inline-block';
    click = 0;
    logAction('Stop', lapTime, totalTime);
}

function updateChronometer() {
    if (chronoRunning) {
        const now = Date.now();
        elapsedTime = now - chronoStartTime;
        document.getElementById('chrono-time').textContent = formatTime(elapsedTime);
    }
}

function formatTime(time) {
    const totalMilliseconds = time;
    const totalSeconds = Math.floor(totalMilliseconds / 1000);//formatē laiku
    const minutes = Math.floor(totalSeconds / 60);
    const seconds = Math.floor(totalSeconds % 60);
    const centiseconds = Math.floor((totalMilliseconds % 1000) / 10);
    return `${minutes.toString().padStart(2, '0')}:${seconds.toString().padStart(2, '0')}:${centiseconds.toString().padStart(2, '0')}`;
}

function recordLap() {
    const lapTime = elapsedTime - lastLapTime;//aprēķina un un tabulā piefixē laikus
    const totalTime = elapsedTime;
    lastLapTime = elapsedTime;
    logAction('Lap', lapTime, totalTime);
}

function logAction(action, lapTime = '', totalTime = '') {
    const now = new Date();
    const date = now.toLocaleDateString();
    const time = now.toLocaleTimeString();

    const tbody = document.getElementById('action-log').querySelector('tbody');//funkcija tabulā augšupielādē informāciju
    const row = tbody.insertRow();
    row.insertCell().textContent = action;
    row.insertCell().textContent = date;
    row.insertCell().textContent = time;
    row.insertCell().textContent = lapTime ? formatTime(lapTime) : '';
    row.insertCell().textContent = formatTime(totalTime);
}

document.getElementById('save-log-btn').addEventListener('click', function() {//saglabā tabulu txt failā
	resetChronometerButtons();
    const table = document.getElementById('action-log');
    const rows = table.querySelectorAll('tbody tr');
    let textContent = 'Action\tDate\tTime\tLap Time\tTotal Time\n';
    rows.forEach(row => {
        Array.from(row.cells).forEach(cell => {
            textContent += cell.textContent + '\t';
        });
        textContent += '\n';
    });
    const blob = new Blob([textContent], { type: 'text/plain' });
    const link = document.createElement('a');
    link.href = window.URL.createObjectURL(blob);
    link.download = 'log.txt';
    link.click();
    window.URL.revokeObjectURL(link.href);
    link.remove();
});
function deleteLog() {
    const tbody = document.getElementById('action-log').querySelector('tbody');
    tbody.innerHTML = '';
    document.getElementById('action-log').style.display = 'none';
}
function resetChronometerButtons() {
    document.getElementById('save-log-btn').style.display = 'none';
    document.getElementById('delete-log-btn').style.display = 'none';//paslēpj hronometra pogas
    document.getElementById('stop-btn').style.display = 'none';
    document.getElementById('lap-btn').style.display = 'none';
    document.getElementById('start-pause-btn').style.display = 'inline-block';
}
document.addEventListener('DOMContentLoaded', function() {
    const hourElement = document.getElementById('hour');
    const minuteElement = document.getElementById('minute');
    const secondElement = document.getElementById('second');
    const modal = document.getElementById('modal');
    const closeButton = document.getElementById('close-modal');
    const applyButton = document.getElementById('apply');

    function updateClock() {
        const now = new Date();
        const hours = now.getHours().        toString().padStart(2, '0');
        const minutes = now.getMinutes().toString().padStart(2, '0');
        const seconds = now.getSeconds().toString().padStart(2, '0');

        hourElement.textContent = hours;
        minuteElement.textContent = minutes;
        secondElement.textContent = seconds;
    }

    updateClock();
    setInterval(updateClock, 1000);

    let selectedColor = '';
    let selectedFont = '';

    function openModal(part) {
        modal.style.display = 'block';
        document.getElementById('modal-part').textContent = part;
    }

    function closeModal() {
        modal.style.display = 'none';
    }

    hourElement.addEventListener('click', function() {
        openModal('Hour');
    });

    minuteElement.addEventListener('click', function() {
        openModal('Minute');
    });

    secondElement.addEventListener('click', function() {
        openModal('Second');
    });

    closeButton.addEventListener('click', function() {
        closeModal();
    });

    applyButton.addEventListener('click', function() { //parmaina krasu/fontu pulkstena dalam
    const color = document.getElementById('color').value;
    const font = document.getElementById('font').value;
    const modalPart = document.getElementById('modal-part').textContent.toLowerCase();

    const clockPart = document.getElementById(modalPart.toLowerCase());
    clockPart.style.color = color;
    clockPart.style.fontFamily = font;

    closeModal();
    saveUserConfig(font, color, modalPart.toLowerCase());
});



    function saveUserConfig(font, color, clockPart) {
    const username = document.getElementById('logged-in-user').textContent;//saglabā lokalajaatminna fontus un krasas

    const fontKey = `${clockPart}_font`;
    const colorKey = `${clockPart}_color`;

    localStorage.setItem(`${username}_${fontKey}`, font);
    localStorage.setItem(`${username}_${colorKey}`, color);
}

    const username = document.getElementById('logged-in-user').textContent;
    const userConfig = JSON.parse(localStorage.getItem(`${username}_config`));
    if (userConfig) {
        applyStyles(userConfig.color, userConfig.font);
    }
});
document.getElementById('download-config-btn').addEventListener('click', function() {//lejupielade lokalas atmina saglabato config
    const username = document.getElementById('logged-in-user').textContent;
    const userConfig = {
        username: username,
        clock: {
            hour: {
                font: localStorage.getItem(`${username}_hour_font`),
                color: localStorage.getItem(`${username}_hour_color`)
            },
            minute: {
                font: localStorage.getItem(`${username}_minute_font`),
                color: localStorage.getItem(`${username}_minute_color`)
            },
            second: {
                font: localStorage.getItem(`${username}_second_font`),
                color: localStorage.getItem(`${username}_second_color`)
            }
        }
    };

    const jsonData = JSON.stringify(userConfig, null, 2);

    const blob = new Blob([jsonData], { type: 'application/json' });

    const link = document.createElement('a');
    link.href = window.URL.createObjectURL(blob);
    link.download = `${username}_clock_config.json`;

    link.click();

    window.URL.revokeObjectURL(link.href);
    link.remove();
});
