// Iegūst elementus no HTML dokumenta
let hoursElem = document.getElementById('hours');
let minutesElem = document.getElementById('minutes');
let secondsElem = document.getElementById('seconds');
let chronoHoursElem = document.getElementById('chronoHours');
let chronoMinutesElem = document.getElementById('chronoMinutes');
let chronoSecondsElem = document.getElementById('chronoSeconds');
let startBtn = document.getElementById('startBtn');
let pauseBtn = document.getElementById('pauseBtn');
let stopBtn = document.getElementById('stopBtn');
let resetBtn = document.getElementById('resetBtn');
let hourColorInput = document.getElementById('hourColor');
let minuteColorInput = document.getElementById('minuteColor');
let secondColorInput = document.getElementById('secondColor');
let fontSelect = document.getElementById('fontSelect');
let resultsElem = document.getElementById('results');
let usernameInput = document.getElementById('username');
let loginBtn = document.getElementById('loginBtn');
let greetingElem = document.getElementById('greeting');
let loginContainer = document.getElementById('login');

// Iniciālie mainīgie
let startTime;
let lapTimes = [];
let running = false;
let paused = false;
let timerInterval;
let username = '';

// Lietotājvārda ievade un sveiciena izvadīšana
loginBtn.addEventListener('click', () => {
    username = usernameInput.value;
    if (username) {
        greetingElem.textContent = `Sveicināti, ${username}!`;
        loginContainer.style.display = 'none';
        loadUserConfig();  // Ielādē lietotāja konfigurāciju pēc pieteikšanās
    }
});

// Atjaunina pulksteņa laiku reāllaikā
function updateClock() {
    let now = new Date();
    hoursElem.textContent = String(now.getHours()).padStart(2, '0');
    minutesElem.textContent = String(now.getMinutes()).padStart(2, '0');
    secondsElem.textContent = String(now.getSeconds()).padStart(2, '0');
    requestAnimationFrame(updateClock);
}

// Sāk hronometru vai pievieno apļa rezultātu
function startChronometer() {
    if (!running) {
        startTime = new Date();
        running = true;
        paused = false;
        lapTimes = [];
        startBtn.textContent = 'Aplis';
        pauseBtn.disabled = false;
        stopBtn.disabled = false;
        resetBtn.disabled = false;
        resultsElem.innerHTML = '';
        addResult('Sākt', startTime);
        timerInterval = setInterval(updateChronometer, 1000);
    } else {
        let now = new Date();
        addResult('Aplis', now);
    }
}

// Atjaunina hronometra laiku reāllaikā
function updateChronometer() {
    if (running && !paused) {
        let now = new Date();
        let elapsedTime = new Date(now - startTime);
        chronoHoursElem.textContent = String(Math.floor(elapsedTime / 3600000)).padStart(2, '0');
        chronoMinutesElem.textContent = String(Math.floor((elapsedTime % 3600000) / 60000)).padStart(2, '0');
        chronoSecondsElem.textContent = String(Math.floor((elapsedTime % 60000) / 1000)).padStart(2, '0');
    }
}

// Pārtrauc hronometru vai atsāk to
function pauseChronometer() {
    if (running) {
        let now = new Date();
        if (!paused) {
            paused = true;
            pauseBtn.textContent = 'Atsākt';
            addResult('Pauze', now);
        } else {
            paused = false;
            pauseBtn.textContent = 'Pauze';
            addResult('Atsākt', now);
        }
    }
}

// Apstādina hronometru un saglabā rezultātus
function stopChronometer() {
    if (running) {
        running = false;
        let now = new Date();
        addResult('Stop', now);
        clearInterval(timerInterval);
        startBtn.textContent = 'Sākt';
        stopBtn.textContent = 'Saglabāt';
        stopBtn.addEventListener('click', saveResults);
        stopBtn.disabled = false;
        resetBtn.disabled = false;
    }
}

// Atiestata hronometru un iztīra rezultātus
function resetChronometer() {
    startBtn.textContent = 'Sākt';
    stopBtn.textContent = 'Stop';
    stopBtn.removeEventListener('click', saveResults);
    startBtn.disabled = false;
    pauseBtn.disabled = true;
    stopBtn.disabled = true;
    resetBtn.disabled = true;
    resultsElem.innerHTML = '';
    chronoHoursElem.textContent = '00';
    chronoMinutesElem.textContent = '00';
    chronoSecondsElem.textContent = '00';
    lapTimes = [];
    running = false;
    paused = false;
    clearInterval(timerInterval);
}

// Saglabā hronometra rezultātus tekstfailā
function saveResults() {
    let resultsText = '';
    lapTimes.forEach(entry => {
        resultsText += `${entry.event}: ${entry.time.toLocaleString()}\n`;
    });
    let blob = new Blob([resultsText], { type: 'text/plain' });
    let a = document.createElement('a');
    a.href = URL.createObjectURL(blob);
    a.download = 'results.txt';
    a.click();
}

// Pievieno rezultātu sarakstam un formatē katru otro rindu
function addResult(event, time) {
    lapTimes.push({ event, time });
    let resultDiv = document.createElement('div');
    resultDiv.textContent = `${event}: ${time.toLocaleString()}`;
    resultsElem.appendChild(resultDiv);

    // Pievieno fona krāsu katrai otrai rindai
    let children = resultsElem.children;
    for (let i = 0; i < children.length; i++) {
        if (i % 2 === 1) {
            children[i].style.backgroundColor = '#f0f0f0';
        } else {
            children[i].style.backgroundColor = '#ffffff';
        }
    }
}

// Izvēlas krāsas stundām, minūtēm un sekundēm
function chooseColors() {
    let hourColor = hourColorInput.value;
    let minuteColor = minuteColorInput.value;
    let secondColor = secondColorInput.value;
    hoursElem.style.color = hourColor;
    minutesElem.style.color = minuteColor;
    secondsElem.style.color = secondColor;
}

// Izvēlas fontu pulksteņa cipariem
function chooseFont() {
    let font = fontSelect.value;
    hoursElem.style.fontFamily = font;
    minutesElem.style.fontFamily = font;
    secondsElem.style.fontFamily = font;
}

// Saglabā lietotāja konfigurāciju
function saveUserConfig() {
    let config = {
        hour_color: hourColorInput.value,
        minute_color: minuteColorInput.value,
        second_color: secondColorInput.value,
        font: fontSelect.value
    };
    localStorage.setItem('user_config', JSON.stringify(config));
}

// Ielādē lietotāja konfigurāciju
function loadUserConfig() {
    let config = JSON.parse(localStorage.getItem('user_config'));
    if (config) {
        hourColorInput.value = config.hour_color;
        minuteColorInput.value = config.minute_color;
        secondColorInput.value = config.second_color;
        fontSelect.value = config.font;
        chooseColors();
        chooseFont();
    }
}

// Sāk pulksteni
updateClock();

// Pievieno notikumu klausītājus
startBtn.addEventListener('click', startChronometer);
pauseBtn.addEventListener('click', pauseChronometer);
stopBtn.addEventListener('click', stopChronometer);
resetBtn.addEventListener('click', resetChronometer);
hourColorInput.addEventListener('input', chooseColors);
minuteColorInput.addEventListener('input', chooseColors);
secondColorInput.addEventListener('input', chooseColors);
fontSelect.addEventListener('change', chooseFont);

// Saglabā lietotāja konfigurāciju izmaiņu gadījumā
hourColorInput.addEventListener('change', saveUserConfig);
minuteColorInput.addEventListener('change', saveUserConfig);
secondColorInput.addEventListener('change', saveUserConfig);
fontSelect.addEventListener('change', saveUserConfig);

// Ielādē lietotāja konfigurāciju, kad lapa ielādējas
document.addEventListener('DOMContentLoaded', loadUserConfig);
