const $tasksBox = $(".tasks");

// Task json template
let obj = {
	nextId: 1,
	tasks: [
		{
			id: 0,
			text: "Hello new user",
			checkBool: true,
			category: 0,
			madeDate: "2024-05-26",
			dueDate: getTodayDate(),
			doneDate: "2024-05-26",
		},
	],
};

// Category json template
let categories = {
	nextId: 2,
	categories: [
		{
			id: 1,
			name: "School",
		},
	],
};

// filtaration default template
const defaultFiltration = {
	search: "",
	category: 0,
	dueDate: getTodayDate(),
	dueDateAll: "",
	madeDate: "",
	madeDateAll: "on",
	doneDate: "",
	doneDateAll: "on",
};

// Events
// open Creation tasks modal
$(".task-create").on("click", (e) => {
	$("#task-modal").modal("toggle");
	$("#task-form")[0].reset();
	$(".form-title").text("Create new task");
	$("#task-due-date").val(getTodayDate());
	$("#task-made-date").val(getTodayDate());
});

// task creating or updating
$("#task-form").on("submit", (e) => {
	e.preventDefault();
	$("#task-modal").modal("toggle");

	const data = objectifyForm($("#task-form").serializeArray());
	if (data.id === "") {
		// task save
		showTask(obj.nextId, data.text, false, data.dueDate);
		obj.tasks.push({
			id: obj.nextId,
			text: data.text,
			checkBool: false,
			category: data.category,
			madeDate: data.madeDate,
			dueDate: data.dueDate,
			doneDate: "",
		});
		obj.nextId++;
	} else {
		// task edit
		const index = obj.tasks.findIndex((task) => task.id == parseInt(data.id));
		const check = obj.tasks[index].checkBool;

		obj.tasks[index] = data;
		obj.tasks[index].checkBool = check;
		showAllTasks(obj.tasks);
	}

	saveTaskData();
	console.log("New task has been saved");
});

// open the category modal
$("#category-btn").on("click", (e) => {
	$("#categories-modal").modal("toggle");
	showCat();
});

// create category in category modal
$("#create-category").on("click", (e) => {
	const cat = $(`
	<div class="mb-3 input-group">
		<span class="input-group-text">Category(${categories.nextId}):</span>
		<input type="text" class="form-control" name="category-name-${categories.nextId}" required />
		<i class="btn btn-primary float-end p-2 fas fa-trash"onclick="deleteCat(this)"></i>
	</div>
	`);
	$("#category-body").append(cat);
	categories.nextId++;
});

// category form submit event
$("#category-form").on("submit", (e) => {
	e.preventDefault();
	$("#categories-modal").modal("toggle");
	const data = $("#category-form").serializeArray();
	let categoryArr = [];
	data.forEach((element) => {
		const id = element.name.split("-")[2];
		categoryArr.push({
			id: id,
			name: element.value,
		});
	});
	categories.categories = categoryArr;
	setAllCategoryToInputs();
	saveCatData();
	console.log("Categories has been updated");
});

// Filtration function and events
$("#filter").on("submit", (e) => {
	e.preventDefault();
});

// Filtration model form input event
$("#filter").on("input", (e) => {
	const data = objectifyForm($("#filter").serializeArray());
	showAllTasks(myFiltration(data));
});

// reset form btn event
$("#reset-filt-form").on("click", (e) => {
	$("#filter")[0].reset();
	oldCheckValue = { dueDateAll: false, doneDateAll: false, madeDateAll: false };
	showAllTasks(myFiltration(defaultFiltration));
});

// default sorting
function defaultSort(tasks = []) {
	if (tasks != []) {
		tasks.sort((a, b) => new Date(b.madeDate) - new Date(a.madeDate));
		tasks.sort((a, b) => new Date(b.dueDate) - new Date(a.dueDate));
		tasks.sort((a, b) => new Date(b.doneDate == "" ? 0 : b.doneDate) - new Date(a.doneDate));
	}
	return tasks;
}

// filtration function
let oldCheckValue = { dueDateAll: false, doneDateAll: false, madeDateAll: false };
function myFiltration(data) {
	let tasks = obj.tasks;

	let { search, category, doneDate, doneDateAll, dueDate, dueDateAll, madeDate, madeDateAll } = data;

	// search filtration
	if (search != "") {
		const regex = new RegExp(search, "i");
		tasks = tasks.filter((e) => {
			return regex.test(e.text);
		});
	}
	// category filtration
	if (category != 0) {
		tasks = tasks.filter((e) => e.category == category);
	}
	// dueDate filtration
	if ((dueDateAll == "on") != oldCheckValue.dueDateAll) {
		oldCheckValue.dueDateAll = !oldCheckValue.dueDateAll;

		if (oldCheckValue.dueDateAll) {
			$("#due-date").val("");
			dueDate = "";
			$("#tasks-week-name").html("All Tasks");
			$("#tasks-date").html("__ ______ ____");
		} else {
			dueDate = getTodayDate();
		}

		$("#dueDateAll").prop("checked", oldCheckValue.dueDateAll);
	}

	if (dueDate) {
		$("#dueDateAll").prop("checked", false);
		oldCheckValue.dueDateAll = false;
		$("#due-date").val(dueDate);
		$("#tasks-week-name").html(getDayOfWeek(dueDate));
		$("#tasks-date").html(formatDate(dueDate));
		tasks = tasks.filter((e) => e.dueDate == dueDate);
	}

	// madeDate filtration
	if ((madeDateAll == "on") != oldCheckValue.madeDateAll) {
		oldCheckValue.madeDateAll = !oldCheckValue.madeDateAll;

		if (oldCheckValue.madeDateAll) {
			$("#input-date").val("");
			madeDate = "";
		} else {
			madeDate = getTodayDate();
		}

		$("#madeDateAll").prop("checked", oldCheckValue.madeDateAll);
	}

	if (madeDate) {
		$("#madeDateAll").prop("checked", false);
		oldCheckValue.madeDateAll = false;
		$("#input-date").val(madeDate);
		tasks = tasks.filter((e) => e.madeDate == madeDate);
	}

	// doneDate filtration
	if ((doneDateAll == "on") != oldCheckValue.doneDateAll) {
		oldCheckValue.doneDateAll = !oldCheckValue.doneDateAll;

		if (oldCheckValue.doneDateAll) {
			$("#completion-date").val("");
			doneDate = "";
		} else {
			doneDate = getTodayDate();
		}

		$("#doneDateAll").prop("checked", oldCheckValue.doneDateAll);
	}

	if (doneDate) {
		$("#doneDateAll").prop("checked", false);
		oldCheckValue.doneDateAll = false;
		$("#completion-date").val(doneDate);
		tasks = tasks.filter((e) => e.doneDate == doneDate);
	}

	return tasks;
}

// Task functions
// show all tasks
function showAllTasks(tasks) {
	const taskCount = 10;
	$tasksBox.html("");
	const sortedTasks = defaultSort(tasks);
	setDownloadFile(sortedTasks)
	for (let i = 0; i < sortedTasks.length; i++) {
		const task = sortedTasks[i];
		showTask(task.id, task.text, task.checkBool, task.dueDate, task.doneDate);
		console.log(i);
		if (i > taskCount) {
			$tasksBox.append(
				$(`
				<div class="mb-1 text-gray fst-italic">+${sortedTasks.length - i} more tasks</div>
				`),
			);
			break;
		}
	}
}

// Show task function
function showTask(id, text, checkBool, dueDate, doneDate) {
	// task template
	const task = $(`
	<div class="form-check mb-1 task" id="task-${id}">
		<input class="form-check-input" id="task-check-${id}" type="checkbox" ${checkBool ? "checked" : ""} onclick="checkUpdate(${id})"/>
		<div class="d-flex justify-content-between">
			<label class="form-check-label" for="task-check-${id}">
				<span class="fst-italic pl-1 task-text">${text}</span>
			</label>

			${doneDate ? `<p class="text-success task-time text-nowrap">done in: ${doneDate}</p>` : `<p class="text-gray task-time text-nowrap">${dueDate}</p>`}
			<div class="btns">
				<i class="btn btn-primary p-2 me-1 fas fa-edit" onclick="updateTask(${id})"></i>
				<i class="btn btn-primary p-2 fas fa-trash" onclick="deleteTask(${id}, this)"></i>
			</div>
		</div>
	</div>
	`);

	$tasksBox.append(task);
}

// Update tasks check
function checkUpdate(id) {
	console.log("check: " + id);
	const index = obj.tasks.findIndex((task) => task.id == id);
	obj.tasks[index].checkBool = !obj.tasks[index].checkBool;

	const $date = $("#task-" + id).find(".task-time");
	if (obj.tasks[index].checkBool) {
		obj.tasks[index].doneDate = getTodayDate();

		$date.text("done in: " + getTodayDate());
		$date.removeClass("text-gray").addClass("text-success");
	} else {
		obj.tasks[index].doneDate = "";
		$date.text(obj.tasks[index].dueDate);
		$date.removeClass("text-success").addClass("text-gray");
	}
	saveTaskData();
}

// Update task
function updateTask(id) {
	const index = obj.tasks.findIndex((task) => task.id == id);
	let task = obj.tasks[index];

	$("#task-modal").modal("toggle");
	$("#task-form")[0].reset();

	$("#task-form [name='id']").val(task.id);
	$("#task-form [name='text']").val(task.text);
	$("#task-form [name='category']").val(task.category);
	$("#task-form [name='dueDate']").val(task.dueDate);
	$("#task-form [name='madeDate']").val(task.madeDate);
	$("#task-form [name='doneDate']").val(task.doneDate);
}

// delete task
function deleteTask(id, element) {
	if (confirm("Delete task? \n" + $(element).parent().parent().find("span").html())) {
		$(element).parent().parent().parent().remove();
		const index = obj.tasks.findIndex((task) => task.id == id);
		let arr = obj.tasks;
		if (index > -1) {
			console.log(arr);
			arr.splice(index, 1);
			console.log(arr);

			obj.tasks = arr;
		}
	}
	saveTaskData();
}

// save task
async function saveTaskData() {
	await $.ajax({
		url: "controllers/tasks.php",
		type: "POST",
		data: { data: JSON.stringify(obj) },
	});
}

// get data from json file
async function getTaskData() {
	let data = await $.ajax({
		url: "controllers/tasks.php",
		type: "GET",
	});

	if (data !== "") {
		data = JSON.parse(data);
		obj = data;
	}

	console.log(obj);
}

// Categoreis functions
function showCat() {
	$("#category-body").html("");
	categories.categories.forEach((category) => {
		const cat = $(`
		<div class="mb-3 input-group">
			<span class="input-group-text">Category(${category.id}):</span>
			<input type="text" class="form-control" name="category-name-${category.id}" value="${category.name}" required />
			<i class="btn btn-primary float-end p-2 fas fa-trash" onclick="deleteCat(this)"></i>
		</div>
		`);
		$("#category-body").append(cat);
	});
}

// delete category
function deleteCat(element) {
	if (confirm("Delete this category?\n" + $(element).parent().find("input").val())) {
		$(element).parent().remove();
		const categoryId = $(element).parent().find("input").attr("name").split("-")[2];
		console.log(categoryId);
		for (const element of obj.tasks) {
			if (element.category == categoryId) element.category = 0;
		}
		saveTaskData();
	}
}

// show all categories in inputs
function setAllCategoryToInputs() {
	let options = '<option value="0">Off top</option>';

	categories.categories.forEach((category) => {
		options += `<option value="${category.id}">${category.name}</option>`;
	});
	$("[id='categories']").each(function () {
		$(this).html("");
		$(this).append(options);
	});
}

// get category data
async function getCatData() {
	let data = await $.ajax({
		url: "controllers/category.php",
		type: "GET",
	});

	if (data !== "") {
		data = JSON.parse(data);
		categories = data;
	}

	console.log(categories);
	setAllCategoryToInputs();
}

// save category data
async function saveCatData() {
	await $.ajax({
		url: "controllers/category.php",
		type: "POST",
		data: { data: JSON.stringify(categories) },
	});
}

// Other functions
//serialize data array to json
function objectifyForm(formArray) {
	let returnArray = {};
	formArray.forEach((element) => {
		returnArray[element["name"]] = element["value"];
	});
	return returnArray;
}

// get date with correct format
function getTodayDate() {
	let today = new Date();
	const dd = String(today.getDate()).padStart(2, "0");
	const mm = String(today.getMonth() + 1).padStart(2, "0");
	const yyyy = today.getFullYear();

	today = yyyy + "-" + mm + "-" + dd;
	return today;
}

// get weekday name
function getDayOfWeek(dateString) {
	const date = new Date(dateString);
	const daysOfWeek = ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
	return daysOfWeek[date.getDay()];
}

// get format date DD month YYYY
function formatDate(dateString) {
	const date = new Date(dateString);
	const options = { day: "2-digit", month: "long", year: "numeric" };
	return date.toLocaleDateString("en-GB", options);
}

// makea blob for tasks downloading
function setDownloadFile(data) {
	let text1 = "Done:\n";
	let text2 = "\nNeed to do:\n";
	data.forEach((e, i) => {
		if (e.checkBool) 
			text1 += `\t${i + 1}. ${e.text}\n`
		else 
			text2 += `\t${i + 1}. ${e.text}\n`
	})
	const blob = new Blob([text1 + text2], { type: "text/plain" });
	const url = URL.createObjectURL(blob);
	const filename = "tasks.txt";
	$("#download-btn").attr("href", url).attr("download", filename);
}

// Greeting function (set username to navbar)
function greeting() {
	const params = new URLSearchParams(window.location.search);
	const username = params.get("username");
	$("#username").text(username);
}

// start
async function start() {
	greeting();
	await getCatData();
	await getTaskData();
	showAllTasks(myFiltration(defaultFiltration));
}
start();
