

window.onload = function () {
  
  //Pārbauda, vai browser local storage ir saglabāts lietotājvārds no iepriekšējas sessijas
  if(localStorage.getItem("login") === null) {
    // Ja lietotājvārda nav, tad uztaisa ievadlauku, lai varētu ievadīt lietotājvārdu
    var loginDiv = document.getElementById("loginDiv");
    var loginInput = document.createElement("input");
    var loginText = document.getElementById("loginText");
    var loginButton = document.createElement("button");

    loginInput.setAttribute('type', 'text');
    loginInput.setAttribute('id', 'login');
    loginInput.setAttribute('class', 'login');
    
    loginButton.textContent = "Pieslēgties";
    loginButton.setAttribute('class', 'loginButton')

    loginDiv.appendChild(loginInput);
    loginDiv.appendChild(loginButton);
    loginText.innerHTML = "Lūdzu ievadiet lietotājvārdu";

    loginButton.addEventListener('click', function() {
        var nickname = loginInput.value;
        // ja lietotājvārda ievadlauks ir tukšs, tad izvada paziņojumu
        if(nickname == "") {

          alert("Lūdzu ievadiet lietotājvārdu!");
        }
        else {
          // ja lietotājvārda ievadlauks nav tukšs, tad saglabā lietotājvārdu browser localstorage un izdzēs ievadlauku.
          localStorage.setItem('login', nickname);
          loginText.innerHTML =   nickname ;
          loginDiv.removeChild(loginInput);
          loginDiv.removeChild(loginButton); 
        }
         
    });

} else {
  // Ja pārbaudot browser local storage, tiek atrasts lietotājvārds no iepriekšejas sessijas, tad uzreiz izvada to lietotājvārdu.
    var nickname = localStorage.getItem("login");
    document.getElementById("loginText").innerHTML =  nickname;
}

  
    var seconds = 0; 
    var tens = 0; 
    var mins = 0;
    var hours = 0;
    var appendTens = document.getElementById("tens");
    var appendSeconds = document.getElementById("timerSeconds");
    var appendMinutes = document.getElementById("timerMinutes");
    var appendHours = document.getElementById("timerHours");
    var buttonStart = document.getElementById('button-start');
    var buttonPause = document.getElementById('button-pause');
    var buttonStop = document.getElementById('button-stop');
    var buttonDelete = document.getElementById('button-delete');
    var Interval ;
    var pauseCount = 0;
    var startCount = 0;
    var loops = 0;
    var actionNr = 1;
    var actionTable = document.getElementById('actionTable');
    var table = document.getElementById("table");
    var stopClickedOnce = false;
    
      // hronometra "sākt" poga
    buttonStart.onclick = function() {
      //uztaisa jauno mainīgu priekš laika
      var date = new Date();
      // noņem "disabled" atribūtu no pauzes un stop pogas, lai tās paliek izmantojamas
      buttonPause.removeAttribute('disabled');
      buttonStop.removeAttribute('disabled');
      clearInterval(Interval);
      Interval = setInterval(startTimer, 10);
      //nomaina pogas tekstu uz Aplis
      buttonStart.textContent = "Aplis";
      
        // ja poga tiek nospiesta otro reizi
      if(startCount >= 1) {
                
          //palielina apļu skaitu
          loops++;
            
          //pievieno jaunu rindu un šūnas tabulai ar apļiem
          let row = table.insertRow(-1);
          let c1 = row.insertCell(0);
          let c2 = row.insertCell(1);
          let c3 = row.insertCell(2);
  
          // Piešķir tekstu šūnām: Apļu skaits, laiks no hronometra un datums ar laiku
          c1.innerText = loops;
          c2.innerText = hours + ":" + mins + ":" + seconds + ":" + tens;
          c3.innerText = date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds() + " " + date.getDate() + "/" + date.getMonth() + "/" + date.getFullYear();

          // pievieno jaunu rindu un šūnas tabulai ar darbībām
          let row2 = actionTable.insertRow(-1);
          c1 = row2.insertCell(0);
          c2 = row2.insertCell(1);
          c3 = row2.insertCell(2);
  
          // Piešķir tekstu šūnām
          c1.innerText = actionNr;
          c2.innerText = "Aplis";
          c3.innerText = date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds() + " " + date.getDate() + "/" + date.getMonth() + "/" + date.getFullYear();
          actionNr++;

      }
      else{ 
        // ja poga nospiesta pirmo reizi, tad arī tiek pievienota jauna rinda tabulai ar darbībam, kur būs rakstīts darbības NR, "Sākums" un datums ar laiku
        let row2 = actionTable.insertRow(-1);
          c1 = row2.insertCell(0);
          c2 = row2.insertCell(1);
          c3 = row2.insertCell(2);
  
          c1.innerText = actionNr;
          c2.innerText = "Sākums";
          c3.innerText = date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds() + " " + date.getDate() + "/" + date.getMonth() + "/" + date.getFullYear();
          actionNr++;
      }

          
  
      startCount++;
  }

          // Poga Pauze
      buttonPause.onclick = function() {
        clearInterval(Interval);
        var date = new Date();
        // Ja pauzes poga tiek nospiesta otro reizi
        if(pauseCount >= 1) {
          // atsāk hronometra darbību
          Interval = setInterval(startTimer, 10);
          buttonPause.textContent = "Pauze"
          buttonStart.removeAttribute('disabled')
          pauseCount--;

          let row2 = actionTable.insertRow(-1);
          c1 = row2.insertCell(0);
          c2 = row2.insertCell(1);
          c3 = row2.insertCell(2);
  
          c1.innerText = actionNr;
          c2.innerText = "Atsākt";
          c3.innerText = date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds() + " " + date.getDate() + "/" + date.getMonth() + "/" + date.getFullYear();
          actionNr++;
        } 
        else {
          // Ja poga tiek nospiesta pirmo reizi
          buttonPause.textContent = "Atsākt";
          buttonStart.setAttribute("disabled", "disabled")
          pauseCount++;
          let row2 = actionTable.insertRow(-1);
          c1 = row2.insertCell(0);
          c2 = row2.insertCell(1);
          c3 = row2.insertCell(2);
  
          c1.innerText = actionNr;
          c2.innerText = "Pauze";
          c3.innerText = date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds() + " " + date.getDate() + "/" + date.getMonth() + "/" + date.getFullYear();
          actionNr++;
        
        }
    }

      // Poga Stop
    buttonStop.onclick = function() {
      // Ja poga nospiesta otro reizi, tad izsauc funkciju download, lai saglabat JSON failu ar abu tabulu datiem
      if (stopClickedOnce) {
          downloadTablesAsJson();
          stopClickedOnce = false; 
  
      } else {
        // Ja poga nospiesta pirmo reizi, tad izdzēs hronometra laiku
          clearInterval(Interval);
          var date = new Date();
          tens = "00";
          seconds = "00";
          mins = "00";
          hours = "00";

          appendTens.innerHTML = tens;
          appendSeconds.innerHTML = seconds;
          appendMinutes.innerHTML = mins;
          appendHours.innerHTML = hours; 
            // Atļauj izmantot pogu izdzēst
          buttonDelete.removeAttribute('disabled');
          buttonPause.textContent = "Pauze";
          buttonStart.textContent = "Sākt";
          buttonPause.setAttribute("disabled", "disabled");
          pauseCount = 0;
          startCount = 0;
          loops = 0;

          let row2 = actionTable.insertRow(-1);
          c1 = row2.insertCell(0);
          c2 = row2.insertCell(1);
          c3 = row2.insertCell(2);

          c1.innerText = actionNr;
          c2.innerText = "Stop";
          c3.innerText = date.getHours() + ":" + date.getMinutes() + ":" + date.getSeconds() + " " + date.getDate() + "/" + date.getMonth() + "/" + date.getFullYear();
          actionNr++;

          buttonStop.innerText = "Saglabāt";

          stopClickedOnce = true; 
          buttonDelete.removeAttribute("disabled")
      }
  }

  
    
      // Poga dzēst
    buttonDelete.onclick = function() {

      buttonStart.innerText = "Sākt"; 
      buttonPause.innerText = "Pauze";
      buttonStop.innerText = "Stop";
      
      buttonStart.removeAttribute('disabled');
      buttonPause.setAttribute("disabled", "disabled");
      buttonStop.setAttribute("disabled", "disabled");

      // Notīra abas tabulas
      removeAllCells(table);
      removeAllCells(actionTable);
      stopClickedOnce = false;

    }
    
    // Hronometra funkcija
    function startTimer () {
      // ātri palielina milisekundes
      tens++; 
      
      // Izvada milisekundes, un ja to ir mazāk par 10, tad pirms tā skaitļa izvada arī ciparu 0
      if(tens <= 9){
        appendTens.innerHTML = "0" + tens;
      }
      
      if (tens > 9){
        appendTens.innerHTML = tens;
        
      } 
      
      // Ja milisekundes sasniedz 100, tad parveido tos par 1 sekundi
      if (tens > 99) {
        seconds++;
        appendSeconds.innerHTML = "0" + seconds;
        tens = 0;
        appendTens.innerHTML = "0" + 0;
      }
      

      if (seconds > 9){
        appendSeconds.innerHTML = seconds;
      }

      //  Ja sekundes sasniedz 60, tad pārveido tos par 1 minūti
      if (seconds == 60) {
        mins++;
        appendMinutes.innerHTML = "0" + mins;
        seconds = 0;
        appendSeconds.innerHTML = "0" + seconds;
      }

      if (mins > 9) {
        appendMinutes.innerHTML = mins;
      }

      // Ja minūtes sasniedz 60, tad pārveido tos par 1 minūti
      if (mins == 60) {
        hours++;
        appendHours.innerHTML = "0" + hours + ":";
        mins = 0;
        appendMinutes.innerHTML = "0" + mins;
      }

      if (hours > 9) {
        appendHours.innerHTML = hours;
      }
    }

    setInterval(showTime, 950);
    // Pulksteņa funkcija
    function showTime() {
      let time = new Date();
      let hour = time.getHours();
      let min = time.getMinutes();
      let sec = time.getSeconds();

      if (sec < 10) {
        sec = "0" + sec;
      }

      if (min < 10) {
        min = "0" + min;
      }

      document.getElementById("hours").innerHTML = hour;
      document.getElementById("minutes").innerHTML = min;
      document.getElementById("seconds").innerHTML = sec;
    }
  }

  
  function colorPicker() {

    // saņem izvēlēto laiku,krāsu un fonta izmēru
    var timeValue = document.getElementById("timeSelect").value;
    var colorValue = document.getElementById('colorSelect').value;
    var fontSize = document.getElementById("fontSelect").value + "px"

    // Piešķir izmaiņas pulkstenim
    document.getElementById(timeValue).style.color = colorValue;
    document.getElementById(timeValue).style.fontSize = fontSize;
    
    
  }

  function saveConfig() {

    if(localStorage.getItem('login') != null) {
      // saglabā pulksteņa konfigurāciju Json failā
      let hourStyle = window.getComputedStyle(document.getElementById('hours'));
      console.log(hourStyle)
      let minuteStyle = window.getComputedStyle(document.getElementById('minutes'));
      let secondStyle = window.getComputedStyle(document.getElementById('seconds'));
      let loginData = localStorage.getItem('login');

      let data = {
        hourStyle: {
          color: hourStyle.color,
          fontSize: hourStyle.fontSize
        },
        minuteStyle: {
          color: minuteStyle.color,
          fontSize: minuteStyle.fontSize
        },
        secondStyle: {
          color: secondStyle.color,
          fontSize: secondStyle.fontSize
        },
        loginData: loginData
      };

      let dataStr = JSON.stringify(data, null, 2);
      let blob = new Blob([dataStr], { type: 'application/json' });
      let link = document.createElement('a');
      link.href = URL.createObjectURL(blob);
      link.download = loginData +'.json';
      document.body.appendChild(link);
      link.click();
      document.body.removeChild(link);

    }
    else {
      alert("Lai saglabāt konfigurāciju, vajag vispirms pieslēgties!")
    }

  }

  function uploadConfig() {
    const fileInput = document.getElementById('fileUpload');
    const file = fileInput.files[0];

    if (file) {
        const reader = new FileReader();
        reader.onload = function(event) {
            const contents = event.target.result;
            parseJSON(contents);
        };
        reader.readAsText(file);
    } else {
        alert('Fails nav izvēlēts!');
    }
}

function parseJSON(contents) {
    try {
        const data = JSON.parse(contents);
        document.getElementById("hours").style.color = ""+data.hourStyle.color;
        document.getElementById("hours").style.fontSize = data.hourStyle.fontSize;

        document.getElementById("minutes").style.color = ""+data.minuteStyle.color;
        document.getElementById("minutes").style.fontSize = data.minuteStyle.fontSize;

        document.getElementById("seconds").style.color = ""+data.secondStyle.color;
        document.getElementById("seconds").style.fontSize = data.secondStyle.fontSize;
    } catch (error) {
        alert('Kļūme! Pārbaudiet, vai izvēlējaties pareizo failu!');
    }
}


function downloadTablesAsJson() {
  // Pārveido tabulu datus JSON formātā izmantojot funkciju "tableToJson"
    var loopsTableData = tableToJson('table');
    var actionTableData = tableToJson('actionTable');
  
    var tablesData = {
        loops: loopsTableData,
        actions: actionTableData
    };

    // Uztaisa BLOB tipa mainīgo un lejupielādē JSON failu ar tabulu datiem
    var jsonStr = JSON.stringify(tablesData, null, 2);
    var blob = new Blob([jsonStr], { type: 'application/json' });
    var url = URL.createObjectURL(blob);
    var a = document.createElement('a');
    a.href = url;
    a.download = 'tablesData.json';
    document.body.appendChild(a);
    a.click();
    document.body.removeChild(a);
    URL.revokeObjectURL(url);
}

function tableToJson(tableId) {
    var table = document.getElementById(tableId);
    var data = [];

    var headers = [];
    for (var i = 0; i < table.rows[0].cells.length; i++) {
        headers[i] = table.rows[0].cells[i].innerText;
    }

    for (var i = 1; i < table.rows.length; i++) {
        var tableRow = table.rows[i];
        var rowData = {};

        for (var j = 0; j < tableRow.cells.length; j++) {
            rowData[headers[j]] = tableRow.cells[j].innerText;
        }

        data.push(rowData);
    }

    return data;
}


function removeAllCells(table) {

  var rows = table.rows;
  for (var i = 1; i < rows.length; i++) {
    var cells = rows[i].cells;
    
    while (cells.length > 0) {
        cells[0].remove();
    }
}

}
