document.addEventListener('DOMContentLoaded', () => {
    const registerBtn = document.getElementById('register-btn');
    const registerModal = document.getElementById('register-modal');
    const registerConfirm = document.getElementById('register-confirm');
    const usernameInput = document.getElementById('username');
    const userNameDisplay = document.getElementById('user-name');
    const todoAppSection = document.getElementById('todo-app');
    const newCategoryInput = document.getElementById('new-category');
    const addCategoryBtn = document.getElementById('add-category');
    const categoryList = document.getElementById('category-list');
    const taskCategorySelect = document.getElementById('task-category');
    const newTaskInput = document.getElementById('new-task');
    const inputDateInput = document.getElementById('input-date');
    const dueDateInput = document.getElementById('due-date');
    const addTaskBtn = document.getElementById('add-task');
    const taskList = document.getElementById('task-list');
    const searchTaskInput = document.getElementById('search-task');
    const filterDateInput = document.getElementById('filter-date');
    const sortTasksSelect = document.getElementById('sort-tasks');
    const exportTasksBtn = document.getElementById('export-tasks');
    const editCategoryModal = document.getElementById('edit-category-modal');
    const editCategoryInput = document.getElementById('edit-category-input');
    const saveCategoryBtn = document.getElementById('save-category');
    const editTaskModal = document.getElementById('edit-task-modal');
    const editTaskNameInput = document.getElementById('edit-task-name');
    const editInputDateInput = document.getElementById('edit-input-date');
    const editDueDateInput = document.getElementById('edit-due-date');
    const editTaskCategorySelect = document.getElementById('edit-task-category');
    const saveTaskBtn = document.getElementById('save-task');
    const closeButtons = document.querySelectorAll('.close');
    const logoutBtn = document.getElementById('logout-btn');
    const userInfo = document.getElementById('user-info');

    let categories = [];
    let tasks = [];
    let currentCategory = null;
    let currentTask = null;

    // Atvērt reģistrācijas modālo logu
    registerBtn.addEventListener('click', () => {
        registerModal.style.display = 'block';
    });

    // Aizvērt modālos logus, noklikšķinot uz aizvēršanas pogas
    closeButtons.forEach(btn => {
        btn.addEventListener('click', () => {
            btn.closest('.modal').style.display = 'none';
        });
    });

    // Reģistrēt lietotāju un parādīt galveno aplikāciju
    registerConfirm.addEventListener('click', () => {
        const username = usernameInput.value.trim();
        if (username) {
            userNameDisplay.textContent = username;
            registerModal.style.display = 'none';
            todoAppSection.style.display = 'block';
            userInfo.style.display = 'flex';
            registerBtn.style.display = 'none';
            loadCategories();
            loadTasks();
        }
    });

    // Izlogot lietotāju un parādīt reģistrācijas skatu
    logoutBtn.addEventListener('click', () => {
        todoAppSection.style.display = 'none';
        userInfo.style.display = 'none';
        registerBtn.style.display = 'block';
        usernameInput.value = '';
        userNameDisplay.textContent = 'Anonymous';
    });

    // Pievienot jaunu kategoriju
    addCategoryBtn.addEventListener('click', () => {
        const category = newCategoryInput.value.trim();
        if (category && !categories.includes(category)) {
            categories.push(category);
            saveCategories();
            updateCategoryList();
        }
    });

    // Pievienot jaunu uzdevumu
    addTaskBtn.addEventListener('click', () => {
        const task = newTaskInput.value.trim();
        const inputDate = inputDateInput.value;
        const dueDate = dueDateInput.value;
        const category = taskCategorySelect.value;
        if (task && inputDate && dueDate) {
            tasks.push({
                task,
                inputDate,
                dueDate,
                actualDate: '',
                category,
                completed: false
            });
            saveTasks();
            updateTaskList();
        }
    });

    // Ielādēt kategorijas no lokālās glabātuves
    function loadCategories() {
        const savedCategories = JSON.parse(localStorage.getItem('categories'));
        if (savedCategories) {
            categories = savedCategories;
            updateCategoryList();
        }
    }

    // Saglabāt kategorijas lokālajā glabātuvē
    function saveCategories() {
        localStorage.setItem('categories', JSON.stringify(categories));
    }

    // Atjaunināt kategoriju sarakstu interfeisā
    function updateCategoryList() {
        categoryList.innerHTML = '';
        taskCategorySelect.innerHTML = '';
        editTaskCategorySelect.innerHTML = '';
        categories.forEach(category => {
            const li = document.createElement('li');
            li.textContent = category;
            const editBtn = document.createElement('button');
            editBtn.textContent = 'Edit';
            editBtn.addEventListener('click', () => {
                currentCategory = category;
                editCategoryInput.value = category;
                editCategoryModal.style.display = 'block';
            });
            const deleteBtn = document.createElement('button');
            deleteBtn.textContent = 'Delete';
            deleteBtn.addEventListener('click', () => {
                categories = categories.filter(c => c !== category);
                tasks = tasks.filter(t => t.category !== category);
                saveCategories();
                saveTasks();
                updateCategoryList();
                updateTaskList();
            });
            li.appendChild(editBtn);
            li.appendChild(deleteBtn);
            categoryList.appendChild(li);

            const option = document.createElement('option');
            option.value = category;
            option.textContent = category;
            taskCategorySelect.appendChild(option);

            const editOption = document.createElement('option');
            editOption.value = category;
            editOption.textContent = category;
            editTaskCategorySelect.appendChild(editOption);
        });
    }

    // Ielādēt uzdevumus no lokālās glabātuves
    function loadTasks() {
        const savedTasks = JSON.parse(localStorage.getItem('tasks'));
        if (savedTasks) {
            tasks = savedTasks;
            updateTaskList();
        }
    }

    // Saglabāt uzdevumus lokālajā glabātuvē
    function saveTasks() {
        localStorage.setItem('tasks', JSON.stringify(tasks));
    }

    // Atjaunināt uzdevumu sarakstu interfeisā
    function updateTaskList() {
        taskList.innerHTML = '';
        let filteredTasks = tasks;
        const filterDate = filterDateInput.value;
        const searchTerm = searchTaskInput.value.toLowerCase();
        if (filterDate) {
            filteredTasks = filteredTasks.filter(task => task.inputDate === filterDate);
        }
        if (searchTerm) {
            filteredTasks = filteredTasks.filter(task => task.task.toLowerCase().includes(searchTerm));
        }
        const sortOption = sortTasksSelect.value;
        filteredTasks.sort((a, b) => new Date(a[sortOption]) - new Date(b[sortOption]));
        filteredTasks.forEach(task => {
            const li = document.createElement('li');
            li.textContent = `${task.task} (Kategorija: ${task.category}, Ievades datums: ${task.inputDate}, Termiņš: ${task.dueDate}, Faktiskais datums: ${task.actualDate || 'N/A'})`;
            const completeBtn = createButton('Atzīmēt kā pabeigtu', () => {
                task.completed = true;
                task.actualDate = new Date().toISOString().split('T')[0];
                saveTasks();
                updateTaskList();
            });
            const editBtn = createButton('Rediģēt', () => {
                currentTask = task;
                editTaskNameInput.value = task.task;
                editInputDateInput.value = task.inputDate;
                editDueDateInput.value = task.dueDate;
                editTaskCategorySelect.value = task.category;
                editTaskModal.style.display = 'block';
            });
            const deleteBtn = createButton('Dzēst', () => {
                tasks = tasks.filter(t => t !== task);
                saveTasks();
                updateTaskList();
            });
            li.appendChild(completeBtn);
            li.appendChild(editBtn);
            li.appendChild(deleteBtn);
            taskList.appendChild(li);
        });
    }

    // Eksportēt filtrētos uzdevumus
    exportTasksBtn.addEventListener('click', () => {
        const filterDate = filterDateInput.value;
        let filteredTasks = tasks;
        if (filterDate) {
            filteredTasks = filteredTasks.filter(task => task.inputDate === filterDate);
        }
        const sortOption = sortTasksSelect.value;
        filteredTasks.sort((a, b) => new Date(a[sortOption]) - new Date(b[sortOption]));

        const text = filteredTasks.map(task => {
            return `Uzdevums: ${task.task}, Kategorija: ${task.category}, Ievades datums: ${task.inputDate}, Termiņš: ${task.dueDate}, Faktiskais datums: ${task.actualDate || 'N/A'}`;
        }).join('\n');
        const blob = new Blob([text], { type: 'text/plain' });
        const url = URL.createObjectURL(blob);
        const a = document.createElement('a');
        a.href = url;
        a.download = 'exported_tasks.txt';
        a.click();
    });

    // Saglabāt rediģēto kategoriju
    saveCategoryBtn.addEventListener('click', () => {
        const newCategory = editCategoryInput.value.trim();
        if (newCategory && currentCategory) {
            categories = categories.map(c => c === currentCategory ? newCategory : c);
            tasks = tasks.map(task => task.category === currentCategory ? { ...task, category: newCategory } : task);
            saveCategories();
            saveTasks();
            updateCategoryList();
            updateTaskList();
            editCategoryModal.style.display = 'none';
        }
    });

    // Saglabāt rediģēto uzdevumu
    saveTaskBtn.addEventListener('click', () => {
        if (currentTask) {
            currentTask.task = editTaskNameInput.value.trim();
            currentTask.inputDate = editInputDateInput.value;
            currentTask.dueDate = editDueDateInput.value;
            currentTask.category = editTaskCategorySelect.value;
            saveTasks();
            updateTaskList();
            editTaskModal.style.display = 'none';
        }
    });

    // Izveidot pogu ar klikšķa funkciju
    function createButton(text, onClick) {
        const button = document.createElement('button');
        button.textContent = text;
        button.addEventListener('click', onClick);
        return button;
    }
});
