new Vue({
  el: '#taskList',
  data: {
    title: 'to do list',
    tasks: [],
    registered: false,
    showModal: false,
    username: '',
    searchQuery: '',
    newTask: {
      name: '',
      category: '',
      inputDate: ''
    },
    editingTask: null,
    filterType: ''
  },
  computed: {
    filteredTasks: function() {
      let filtered = this.tasks.filter(task => {
        return task.name.toLowerCase().includes(this.searchQuery.toLowerCase());
      });
      if (this.filterType === 'inputDate') {
        filtered = filtered.sort((a, b) => new Date(a.inputDate) - new Date(b.inputDate));
      } else if (this.filterType === 'completionDate') {
        filtered = filtered.sort((a, b) => new Date(a.completionDate) - new Date(b.completionDate));
      } else if (this.filterType === 'actualCompletionDate') {
        filtered = filtered.sort((a, b) => new Date(a.actualCompletionDate) - new Date(b.actualCompletionDate));
      }
      return filtered;
    },
    uniqueCategories: function() {
      return [...new Set(this.tasks.map(task => task.category))];
    },
    sortedTasks: function() {
      return this.filteredTasks.sort((a, b) => new Date(a.inputDate) - new Date(b.inputDate));
    }
  },
  methods: {
    showRegistration: function() {
      this.showModal = true;
    },
    closeModal: function() {
      if (!this.username) {
        alert("Please enter a username.");
        return;
      }
      this.showModal = false;
      this.registered = true;
    },
    registerUser: function() {
      if (!this.username) {
        alert("Please enter a username.");
        return;
      }
      this.registered = true;
      this.closeModal();
    },
    addTask: function() {
      if (!this.newTask.name || !this.newTask.inputDate) {
        return;
      }
      this.tasks.push({
        name: this.newTask.name,
        category: this.newTask.category,
        inputDate: this.newTask.inputDate,
        completionDate: '',
        actualCompletionDate: ''
      });
      this.newTask.name = '';
      this.newTask.category = '';
      this.newTask.inputDate = '';
    },
    completeTask: function(task) {
      if (!task.completionDate) {
        task.completionDate = new Date().toLocaleDateString();
        task.actualCompletionDate = new Date().toLocaleString();
      } else {
        task.completionDate = '';
        task.actualCompletionDate = '';
      }
    },
    editTask: function(task) {
      this.editingTask = task;
    },
    saveTask: function(task) {
      this.editingTask = null;
    },
    delItem: function (task) {
      this.tasks.splice(this.tasks.indexOf(task), 1)
    },
    filterByInputDate: function() {
      this.filterType = 'inputDate';
    },
    filterByCompletionDate: function() {
      this.filterType = 'completionDate';
    },
    filterByActualCompletionDate: function() {
      this.filterType = 'actualCompletionDate';
    }
  }
});