var users = []; // Array to store registered users
var currentUser = null;

// Check if there are saved users in localStorage
var savedUsers = localStorage.getItem('users');
if (savedUsers) {
    users = JSON.parse(savedUsers);
}

// Check if there is a logged-in user in localStorage
var savedUser = localStorage.getItem('currentUser');
if (savedUser) {
    currentUser = savedUser;
    showLoggedInUser(currentUser);
}

function toggleForm() {
    var loginForm = document.getElementById("loginForm");
    var signupForm = document.getElementById("signupForm");
    if (loginForm.style.display === "none") {
        loginForm.style.display = "block";
        signupForm.style.display = "none";
    } else {
        loginForm.style.display = "none";
        signupForm.style.display = "block";
    }
}

function login() {
    var username = document.getElementById("loginUsername").value;
    var password = document.getElementById("loginPassword").value;
    var user = users.find(function(user) {
        return user.username === username && user.password === password;
    });
    if (user) {
        currentUser = username;
        localStorage.setItem('currentUser', currentUser);
        document.getElementById("loginForm").style.display = "none";
        document.getElementById("taskForm").style.display = "block";
        document.getElementById("userInfo").style.display = "block";
        showLoggedInUser(currentUser);
    } else {
        alert("Invalid username or password");
    }
}

function signup() {
    var username = document.getElementById("signupUsername").value;
    var password = document.getElementById("signupPassword").value;
    users.push({ username: username, password: password });
    localStorage.setItem('users', JSON.stringify(users));
    alert("Sign up successful! You can now login.");
    toggleForm();
}

function logout() {
    currentUser = null;
    localStorage.removeItem('currentUser');
    document.getElementById("taskForm").style.display = "none";
    document.getElementById("userInfo").style.display = "none";
    document.getElementById("loginForm").style.display = "block";
}

function showLoggedInUser(username) {
    var userInfo = document.getElementById("userInfo");
    userInfo.innerHTML = "<p>Logged in as: " + username + "</p>";
}

function addTask() {
    var taskInput = document.getElementById("taskInput");
    var taskDate = document.getElementById("taskDate").value;
    var categorySelect = document.getElementById("categorySelect");
    var category = categorySelect.options[categorySelect.selectedIndex].value;
    var taskText = taskInput.value;
    if (taskText.trim() !== "" && taskDate) {
        var taskList = document.getElementById("taskList");
        var li = document.createElement("li");
        var taskSpan = document.createElement("span");

        // Get the current time
        var now = new Date();
        var hours = String(now.getHours()).padStart(2, '0');
        var minutes = String(now.getMinutes()).padStart(2, '0');
        var currentTime = `${hours}:${minutes}`;

        taskSpan.textContent = `${taskText} - ${taskDate} ${currentTime} (${category})`;

        var editButton = document.createElement("button");
        editButton.textContent = "✏️";
        editButton.className = "edit";
        editButton.onclick = function() {
            var newTaskText = prompt("Edit your task:", taskText);
            if (newTaskText !== null) {
                taskText = newTaskText; // Update taskText variable
                taskSpan.textContent = `${taskText} - ${taskDate} ${currentTime} (${category})`;
            }
        };

        var deleteButton = document.createElement("button");
        deleteButton.textContent = "❌";
        deleteButton.className = "delete";
        deleteButton.onclick = function() {
            taskList.removeChild(li);
        };

        li.appendChild(taskSpan);
        li.appendChild(editButton);
        li.appendChild(deleteButton);
        taskList.appendChild(li);
        taskInput.value = "";
    } else {
        alert("Please enter all task details.");
    }
}

function searchTasks() {
    var searchText = document.getElementById("searchInput").value.toLowerCase();
    var taskList = document.getElementById("taskList");
    var tasks = taskList.getElementsByTagName("li");

    for (var i = 0; i < tasks.length; i++) {
        var task = tasks[i];
        var taskText = task.textContent.toLowerCase();

        if (taskText.includes(searchText)) {
            task.style.display = "block";
        } else {
            task.style.display = "none";
        }
    }
}

function exportTasks() {
    var tasks = document.getElementById("taskList").getElementsByTagName("li");
    var textToWrite = "";

    for (var i = 0; i < tasks.length; i++) {
        textToWrite += tasks[i].getElementsByTagName("span")[0].textContent + "\n";
    }

    var blob = new Blob([textToWrite], { type: "text/plain" });
    var url = URL.createObjectURL(blob);

    var a = document.createElement("a");
    a.href = url;
    a.download = "tasks.txt";
    a.click();

    URL.revokeObjectURL(url);
}
