function login() {
  var loginUsername = document.getElementById('loginUsername').value;
  if (loginUsername.trim() !== "") {
      localStorage.setItem('username', loginUsername);
      showTodoListPage();
      displayTasks();
  } else {
      alert('Please enter a username.');
  }
}

function addTask() {
  var todoInput = document.getElementById('todoInput').value;
  if (todoInput.trim() !== "") {
      var date = prompt("Enter due date (optional):");
      var username = localStorage.getItem('username');
      var todoList = JSON.parse(localStorage.getItem(username)) || [];
      todoList.push({ text: todoInput, date: date ? date : null, completed: false }); 
      localStorage.setItem(username, JSON.stringify(todoList));
      displayTasks();
      document.getElementById('todoInput').value = ''; 
  } else {
      alert('Please enter a task.');
  }
}

function addDate() {
  var todoInput = document.getElementById('todoInput').value;
  if (todoInput.trim() !== "") {
      var date = prompt("Enter due date (optional):");
      var username = localStorage.getItem('username');
      var todoList = JSON.parse(localStorage.getItem(username)) || [];
      todoList.push({ text: todoInput, date: date ? date : null, completed: false }); 
      localStorage.setItem(username, JSON.stringify(todoList));
      displayTasks();
      document.getElementById('todoInput').value = '';
  } else {
      alert('Please enter a task.');
  }
}

function toggleTask(index) {
  var username = localStorage.getItem('username');
  var todoList = JSON.parse(localStorage.getItem(username)) || [];
  todoList[index].completed = !todoList[index].completed;
  localStorage.setItem(username, JSON.stringify(todoList));
  displayTasks();
}

function deleteTask(index) {
  var username = localStorage.getItem('username');
  var todoList = JSON.parse(localStorage.getItem(username)) || [];
  todoList.splice(index, 1);
  localStorage.setItem(username, JSON.stringify(todoList));
  displayTasks();
}

function deleteAllTasks() {
  var username = localStorage.getItem('username');
  localStorage.removeItem(username);
  displayTasks();
}

function displayTasks() {
  var username = localStorage.getItem('username');
  var todoList = JSON.parse(localStorage.getItem(username)) || [];
  var todoListContainer = document.getElementById("todoList");
  todoListContainer.innerHTML = ""; 
  todoList.forEach(function(task, index) {
      var taskItem = document.createElement("li");
      taskItem.textContent = task.text;
      if (task.date) {
          taskItem.textContent += " (Due Date: " + task.date + ")";
      }
      if (task.completed) { 
          taskItem.style.textDecoration = "line-through";
      }
      taskItem.addEventListener('click', function() { 
          toggleTask(index);
      });
      var deleteButton = document.createElement("button");
      deleteButton.textContent = "Delete";
      deleteButton.onclick = function() {
          deleteTask(index);
      };
      taskItem.appendChild(deleteButton);
      todoListContainer.appendChild(taskItem);
  });
}

function showTodoListPage() {
  document.getElementById('loginPage').style.display = 'none';
  document.getElementById('todoListPage').style.display = 'block';
}

function logout() {
  localStorage.removeItem('username');
  document.getElementById('todoListPage').style.display = 'none';
  document.getElementById('loginPage').style.display = 'block';
}

window.onload = function() {
  var username = localStorage.getItem('username');
  if (username) {
      showTodoListPage();
      displayTasks();
  }
}