document.addEventListener('DOMContentLoaded', () => {
    const usernameInput = document.getElementById('username');
    const registerBtn = document.getElementById('register-btn');
    const loggedInUser = document.getElementById('user-name');
    const registerLoginSection = document.getElementById('register-login');
    const todoAppSection = document.getElementById('todo-app');
    const categoryList = document.getElementById('category-list');
    const newCategoryInput = document.getElementById('new-category');
    const addCategoryBtn = document.getElementById('add-category');
    const taskCategorySelect = document.getElementById('task-category');
    const newTaskInput = document.getElementById('new-task');
    const inputDateInput = document.getElementById('input-date');
    const dueDateInput = document.getElementById('due-date');
    const addTaskBtn = document.getElementById('add-task');
    const taskList = document.getElementById('task-list');
    const filterDateInput = document.getElementById('filter-date');
    const sortTasksSelect = document.getElementById('sort-tasks');
    const exportTasksBtn = document.getElementById('export-tasks');
    const searchTaskInput = document.getElementById('search-task');
    const editCategoryModal = document.getElementById('edit-category-modal');
    const editCategoryInput = document.getElementById('edit-category-input');
    const saveCategoryBtn = document.getElementById('save-category');
    const editTaskModal = document.getElementById('edit-task-modal');
    const editTaskName = document.getElementById('edit-task-name');
    const editInputDate = document.getElementById('edit-input-date');
    const editDueDate = document.getElementById('edit-due-date');
    const editTaskCategorySelect = document.getElementById('edit-task-category');
    const saveTaskBtn = document.getElementById('save-task');

    let categories = [];
    let tasks = [];
    let currentCategory = null;
    let currentTask = null;

    // Reģistrācija un pieteikšanās
    registerBtn.addEventListener('click', () => {
        const username = usernameInput.value.trim();
        if (username) {
            loggedInUser.textContent = username;
            registerLoginSection.style.display = 'none';
            todoAppSection.style.display = 'block';
            loadCategories();
            loadTasks();
        }
    });

    // Kategoriju pievienošana
    addCategoryBtn.addEventListener('click', () => {
        const category = newCategoryInput.value.trim();
        if (category && !categories.includes(category)) {
            categories.push(category);
            saveCategories();
            updateCategoryList();
        }
    });

    // Darbu pievienošana
    addTaskBtn.addEventListener('click', () => {
        const task = newTaskInput.value.trim();
        const inputDate = inputDateInput.value;
        const dueDate = dueDateInput.value;
        const category = taskCategorySelect.value;

        if (task && inputDate && dueDate) {
            const newTask = {
                task,
                inputDate,
                dueDate,
                actualDate: '',
                category,
                completed: false
            };
            tasks.push(newTask);
            saveTasks();
            updateTaskList();
        }
    });

    // Filtrēšana un kārtošana
    filterDateInput.addEventListener('change', updateTaskList);
    sortTasksSelect.addEventListener('change', updateTaskList);
    exportTasksBtn.addEventListener('click', exportFilteredTasks);

    // Meklēšana
    searchTaskInput.addEventListener('input', updateTaskList);

    function loadCategories() {
        // Load categories from local storage or JSON file
        const savedCategories = JSON.parse(localStorage.getItem('categories'));
        if (savedCategories) {
            categories = savedCategories;
            updateCategoryList();
        }
    }

    function saveCategories() {
        localStorage.setItem('categories', JSON.stringify(categories));
    }

    function updateCategoryList() {
        categoryList.innerHTML = '';
        taskCategorySelect.innerHTML = '';
        editTaskCategorySelect.innerHTML = '';
        categories.forEach(category => {
            const li = document.createElement('li');
            li.textContent = category;
            const editBtn = document.createElement('button');
            editBtn.textContent = 'Rediģēt';
            editBtn.addEventListener('click', () => {
                currentCategory = category;
                editCategoryInput.value = category;
                editCategoryModal.style.display = 'block';
            });
            const deleteBtn = document.createElement('button');
            deleteBtn.textContent = 'Dzēst';
            deleteBtn.addEventListener('click', () => {
                categories = categories.filter(c => c !== category);
                saveCategories();
                updateCategoryList();
            });
            li.appendChild(editBtn);
            li.appendChild(deleteBtn);
            categoryList.appendChild(li);

            const option = document.createElement('option');
            option.value = category;
            option.textContent = category;
            taskCategorySelect.appendChild(option);

            const editOption = document.createElement('option');
            editOption.value = category;
            editOption.textContent = category;
            editTaskCategorySelect.appendChild(editOption);
        });
    }

    function loadTasks() {
        // Load tasks from local storage or JSON file
        const savedTasks = JSON.parse(localStorage.getItem('tasks'));
        if (savedTasks) {
            tasks = savedTasks;
            updateTaskList();
        }
    }

    function saveTasks() {
        localStorage.setItem('tasks', JSON.stringify(tasks));
    }

    function updateTaskList() {
        taskList.innerHTML = '';
        let filteredTasks = tasks;
        const filterDate = filterDateInput.value;
        const searchTerm = searchTaskInput.value.toLowerCase();
        if (filterDate) {
            filteredTasks = filteredTasks.filter(task => task.inputDate === filterDate);
        }
        if (searchTerm) {
            filteredTasks = filteredTasks.filter(task => task.task.toLowerCase().includes(searchTerm));
        }
        const sortOption = sortTasksSelect.value;
        filteredTasks.sort((a, b) => new Date(a[sortOption]) - new Date(b[sortOption]));
        filteredTasks.slice(0, 10).forEach(task => {
            const li = document.createElement('li');
            li.textContent = `${task.task} (Kategorija: ${task.category}, Ievades datums: ${task.inputDate}, Izpildes datums: ${task.dueDate}, Faktiskais izpildes datums: ${task.actualDate || 'N/A'})`;
            const completeBtn = document.createElement('button');
            completeBtn.textContent = 'Atzīmēt kā izpildītu';
            completeBtn.addEventListener('click', () => {
                task.completed = true;
                task.actualDate = new Date().toISOString().split('T')[0];
                saveTasks();
                updateTaskList();
            });
            const editBtn = document.createElement('button');
            editBtn.textContent = 'Rediģēt';
            editBtn.addEventListener('click', () => {
                currentTask = task;
                editTaskName.value = task.task;
                editInputDate.value = task.inputDate;
                editDueDate.value = task.dueDate;
                editTaskCategorySelect.value = task.category;
                editTaskModal.style.display = 'block';
            });
            const deleteBtn = document.createElement('button');
            deleteBtn.textContent = 'Dzēst';
            deleteBtn.addEventListener('click', () => {
                tasks = tasks.filter(t => t !== task);
                saveTasks();
                updateTaskList();
            });
            li.appendChild(completeBtn);
            li.appendChild(editBtn);
            li.appendChild(deleteBtn);
            taskList.appendChild(li);
        });
    }

    function exportFilteredTasks() {
        const filterDate = filterDateInput.value;
        let filteredTasks = tasks;
        if (filterDate) {
            filteredTasks = filteredTasks.filter(task => task.inputDate === filterDate);
        }
        const sortOption = sortTasksSelect.value;
        filteredTasks.sort((a, b) => new Date(a[sortOption]) - new Date(b[sortOption]));

        const text = filteredTasks.map(task => {
            return `Darbs: ${task.task}, Kategorija: ${task.category}, Ievades datums: ${task.inputDate}, Izpildes datums: ${task.dueDate}, Faktiskais izpildes datums: ${task.actualDate || 'N/A'}`;
        }).join('\n');

        const blob = new Blob([text], { type: 'text/plain' });
        const url = URL.createObjectURL(blob);
        const a = document.createElement('a');
        a.href = url;
        a.download = 'exported_tasks.txt';
        a.click();
    }

    // Modālo logu aizvēršana
    document.querySelectorAll('.close').forEach(closeBtn => {
        closeBtn.addEventListener('click', () => {
            closeBtn.closest('.modal').style.display = 'none';
        });
    });

    // Saglabāt rediģēto kategoriju
    saveCategoryBtn.addEventListener('click', () => {
        const newCategory = editCategoryInput.value.trim();
        if (newCategory && currentCategory) {
            categories = categories.map(c => c === currentCategory ? newCategory : c);
            tasks = tasks.map(task => task.category === currentCategory ? { ...task, category: newCategory } : task);
            saveCategories();
            saveTasks();
            updateCategoryList();
            updateTaskList();
            editCategoryModal.style.display = 'none';
        }
    });

    // Saglabāt rediģēto darbu
    saveTaskBtn.addEventListener('click', () => {
        if (currentTask) {
            currentTask.task = editTaskName.value.trim();
            currentTask.inputDate = editInputDate.value;
            currentTask.dueDate = editDueDate.value;
            currentTask.category = editTaskCategorySelect.value;
            saveTasks();
            updateTaskList();
            editTaskModal.style.display = 'none';
        }
    });
});
