let users = [];
let currentUser = null;
let jobs = [];
let categories = ["Personīgi", "Darbs", "Cits"]; // Sample categories

function updateJobCategorySelect() {
    const jobCategorySelect = document.getElementById('job-category');
    jobCategorySelect.innerHTML = categories.map(category => `<option value="${category}">${category}</option>`).join('');
}

function renderCategories() {
    const categoryList = document.getElementById('category-list');
    categoryList.innerHTML = categories.map((category, index) => `
        <li class="category-item" data-index="${index}">
            ${category}
            <button onclick="editCategory(${index})">Rediģēt</button>
            <button onclick="deleteCategory(${index})">Dzēst</button>
        </li>
    `).join('');
}

function renderJobs(filter = {}) {
    const jobList = document.getElementById('job-list');
    let filteredJobs = jobs;

    if (filter.entryDate) {
        filteredJobs = filteredJobs.filter(job => job.entryDate === filter.entryDate);
    }
    if (filter.dueDate) {
        filteredJobs = filteredJobs.filter(job => job.executionDate === filter.dueDate);
    }
    if (filter.actualDate) {
        filteredJobs = filteredJobs.filter(job => job.actualDueDate === filter.actualDate);
    }
    if (filter.search) {
        filteredJobs = filteredJobs.filter(job => job.title.toLowerCase().includes(filter.search.toLowerCase()));
    }

    jobList.innerHTML = filteredJobs.map(job => `
        <li class="job-item ${job.done ? 'done' : ''}" data-id="${job.id}">
            ${job.title} - ${job.category} - ${job.entryDate} - ${job.executionDate} - ${job.actualDueDate}
            <button onclick="editJob(${job.id})">Rediģēt</button>
            <button onclick="deleteJob(${job.id})">Dzēst</button>
            <button onclick="markAsDone(${job.id})">${job.done ? 'Atpakaļ' : 'Gatavs'}</button>
        </li>
    `).join('');
}

document.addEventListener('DOMContentLoaded', () => {
    const loginForm = document.getElementById('user-registration');
    const usernameInput = document.getElementById('username');
    const loggedInUserDiv = document.getElementById('logged-in-user');
    const jobForm = document.getElementById('job-form');
    const exportDataButton = document.getElementById('export-data');
    const searchJobInput = document.getElementById('search-job');
    const filterEntryDateInput = document.getElementById('filter-entry-date');
    const filterDueDateInput = document.getElementById('filter-due-date');
    const filterActualDateInput = document.getElementById('filter-actual-date');
    const categoryForm = document.getElementById('category-form');
    const categoryNameInput = document.getElementById('category-name');

    loginForm.addEventListener('submit', (e) => {
        e.preventDefault();
        const username = usernameInput.value;
        if (!users.includes(username)) {
            users.push(username);
        }
        currentUser = username;
        loggedInUserDiv.innerText = `Esat ienācis kā: ${currentUser}`;
        loggedInUserDiv.style.display = 'block';
        loginForm.style.display = 'none';
    });

    jobForm.addEventListener('submit', (e) => {
        e.preventDefault();
        const jobTitle = document.getElementById('job-title').value;
        const jobCategory = document.getElementById('job-category').value;
        const entryDate = document.getElementById('entry-date').value;
        const executionDate = document.getElementById('execution-date').value;
        const actualDueDate = document.getElementById('actual-due-date').value;

        const job = {
            id: Date.now(),
            title: jobTitle,
            category: jobCategory,
            entryDate: entryDate,
            executionDate: executionDate,
            actualDueDate: actualDueDate,
            done: false
        };

        jobs.push(job);
        renderJobs();
    });

    categoryForm.addEventListener('submit', (e) => {
        e.preventDefault();
        const categoryName = categoryNameInput.value;
        if (categoryName && !categories.includes(categoryName)) {
            categories.push(categoryName);
            categoryNameInput.value = '';
            updateJobCategorySelect();
            renderCategories();
        }
    });

    exportDataButton.addEventListener('click', () => {
        const blob = new Blob([JSON.stringify(jobs, null, 2)], { type: 'text/plain' });
        const url = URL.createObjectURL(blob);
        const a = document.createElement('a');
        a.href = url;
        a.download = 'jobs.txt';
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
    });

    searchJobInput.addEventListener('input', () => {
        renderJobs({ search: searchJobInput.value });
    });

    filterEntryDateInput.addEventListener('change', () => {
        renderJobs({ entryDate: filterEntryDateInput.value });
    });

    filterDueDateInput.addEventListener('change', () => {
        renderJobs({ dueDate: filterDueDateInput.value });
    });

    filterActualDateInput.addEventListener('change', () => {
        renderJobs({ actualDate: filterActualDateInput.value });
    });

    updateJobCategorySelect();
    renderCategories();
    renderJobs();
});

function editCategory(index) {
    const newCategoryName = prompt("Ievaduet kategorijas nosaukumu:", categories[index]);
    if (newCategoryName && newCategoryName !== categories[index]) {
        categories[index] = newCategoryName;
        updateJobCategorySelect();
        renderCategories();
    }
}

function deleteCategory(index) {
    if (confirm("Vai tu esi parliecināts?")) {
        categories.splice(index, 1);
        updateJobCategorySelect();
        renderCategories();
    }
}

function editJob(id) {
    
}

function deleteJob(id) {
    console.log("Dzēš darbu ar id:", id);
    const index = jobs.findIndex(job => job.id === id);
    console.log("Darba index kuru vajag izdzēst:", index);
    if (index !== -1) {
        jobs.splice(index, 1);
        console.log("Darbs izdzēsts");
        renderJobs();
    } else {
        console.log("Darbs nav atrasts");
    }
}

function markAsDone(id) {
    const job = jobs.find(job => job.id === id);
    if (job) {
        job.done = !job.done;
        renderJobs(); 
    }
}
window.editCategory = editCategory;
window.deleteCategory = deleteCategory;
window.editJob = editJob;
window.deleteJob = deleteJob;
window.markAsDone = markAsDone;
