// Ielādē jaunu lapu ar konkrētā lietotaja profilu un formatiem.
window.onload = function() {
  var queryString = window.location.search;
  var urlParams = new URLSearchParams(queryString);
  var username = urlParams.get('username');

  if (username) {
    document.getElementById('username').textContent = username;
    loadUserFormat(username);
    updateClock();
    setInterval(updateClock, 100);
  }

  // Funkcija, kas atjaunina pulksteņa laiku un formātu
  function updateClock() {
    var now = new Date();
    var hours = now.getHours().toString().padStart(2, '0');
    var minutes = now.getMinutes().toString().padStart(2, '0');
    var seconds = now.getSeconds().toString().padStart(2, '0');

    var hoursFont = document.getElementById('hoursFont').value;
    var minutesFont = document.getElementById('minutesFont').value;
    var secondsFont = document.getElementById('secondsFont').value;

    var hoursColor = document.getElementById('hoursColor').value;
    var minutesColor = document.getElementById('minutesColor').value;
    var secondsColor = document.getElementById('secondsColor').value;

    var clockElement = document.getElementById('clock');
    clockElement.innerHTML = `<span id="hours" style="color:${hoursColor}; font-family:${hoursFont}">${hours}</span>:<span id="minutes" style="color:${minutesColor}; font-family:${minutesFont}">${minutes}</span>:<span id="seconds" style="color:${secondsColor}; font-family:${secondsFont}">${seconds}</span>`;
  }

  // Funkcija, kas parāda iestatījumu uznirstošo logu
  //@param {string} popupId - uznirstošā loga ID
  function showPopup(popupId) {
    var popup = document.getElementById(popupId);
    popup.style.display = 'block';
  }

  // Funkcija, kas paslēpj visus uznirstošos logus
  function hidePopups() {
    document.querySelectorAll('.popup').forEach(popup => popup.style.display = 'none');
  }

  
   // Funkcija, kas saglabā pulksteņa formātu kā JSON failu
   
  function saveClockFormat() {
    var hoursFont = document.getElementById('hoursFont').value;
    var minutesFont = document.getElementById('minutesFont').value;
    var secondsFont = document.getElementById('secondsFont').value;

    var hoursColor = document.getElementById('hoursColor').value;
    var minutesColor = document.getElementById('minutesColor').value;
    var secondsColor = document.getElementById('secondsColor').value;

    var format = {
      user: username, 
      hoursFont: hoursFont,
      minutesFont: minutesFont,
      secondsFont: secondsFont,
      hoursColor: hoursColor,
      minutesColor: minutesColor,
      secondsColor: secondsColor
    };

    var blob = new Blob([JSON.stringify(format, null, 2)], { type: 'application/json' });
    var url = URL.createObjectURL(blob);
    var a = document.createElement('a');
    a.href = url;
    a.download = 'plkst_formats.json';
    document.body.appendChild(a);
    a.click();
    document.body.removeChild(a);
  }

  
   // Funkcija, kas saglabā lietotāja iestatījumus pārlūka vietējā atmiņā
   
  function saveUserFormat() {
    var hoursFont = document.getElementById('hoursFont').value;
    var minutesFont = document.getElementById('minutesFont').value;
    var secondsFont = document.getElementById('secondsFont').value;

    var hoursColor = document.getElementById('hoursColor').value;
    var minutesColor = document.getElementById('minutesColor').value;
    var secondsColor = document.getElementById('secondsColor').value;

    var format = {
      hoursFont: hoursFont,
      minutesFont: minutesFont,
      secondsFont: secondsFont,
      hoursColor: hoursColor,
      minutesColor: minutesColor,
      secondsColor: secondsColor
    };

    var userFormat = {
      username: username,
      format: format
    };

    localStorage.setItem(`clockFormat_${username}`, JSON.stringify(userFormat));
    alert('Lietotaja formats saglabats!');
  }

  
    //Funkcija, kas ielādē lietotāja saglabātos iestatījumus no pārlūka vietējās atmiņas
    //@param {string} username - lietotājvārds, kuru iestatījumi ir jāielādē
   
  function loadUserFormat(username) {
    var savedUserFormat = localStorage.getItem(`clockFormat_${username}`);
    if (savedUserFormat) {
      var userFormat = JSON.parse(savedUserFormat);
      var format = userFormat.format;
      document.getElementById('hoursFont').value = format.hoursFont;
      document.getElementById('minutesFont').value = format.minutesFont;
      document.getElementById('secondsFont').value = format.secondsFont;

      document.getElementById('hoursColor').value = format.hoursColor;
      document.getElementById('minutesColor').value = format.minutesColor;
      document.getElementById('secondsColor').value = format.secondsColor;
    }
  }

  // Pievieno eventlistener pogai "Save User Format"
  document.getElementById('save-user-format-button').addEventListener('click', saveUserFormat);

  // Pievieno eventlistener klikšķa notikumam uz pulksteņa elementa
  document.getElementById('clock').addEventListener('click', function(event) {
    var targetId = event.target.id;
    hidePopups();
    if (targetId === 'hours') {
      showPopup('hoursPopup');
    } else if (targetId === 'minutes') {
      showPopup('minutesPopup');
    } else if (targetId === 'seconds') {
      showPopup('secondsPopup');
    }
  });

  // Pievieno eventlistener izlogošanās pogai
  document.getElementById('logout-button').addEventListener('click', function() {
    window.location.href = 'index.html';
  });

  // Pievieno eventlistener pogai "Save Format"
  document.getElementById('save-format-button').addEventListener('click', saveClockFormat);
  document.getElementById('save-user-format-button').addEventListener('click', saveUserFormat);

  // Pievieno eventlistener stilu un krāsu izmaiņām, lai atjauninātu pulksteni reāllaikā
  document.getElementById('hoursFont').addEventListener('change', updateClock);
  document.getElementById('minutesFont').addEventListener('change', updateClock);
  document.getElementById('secondsFont').addEventListener('change', updateClock);

  document.getElementById('hoursColor').addEventListener('input', updateClock);
  document.getElementById('minutesColor').addEventListener('input', updateClock);
  document.getElementById('secondsColor').addEventListener('input', updateClock);

  // Pievieno eventlistener klikšķiem dokumentā, lai paslēptu uznirstošos logus, kad klikšķis notiek ārpus tiem
  document.addEventListener('click', function(event) {
    if (!event.target.closest('.popup') && !event.target.closest('.clock span')) {
      hidePopups();
    }
  });
}